package com.liquidnet.service.goblin.param;

import com.liquidnet.service.goblin.entity.GoblinOrderAttr;
import com.liquidnet.service.goblin.entity.GoblinOrderSku;
import com.liquidnet.service.goblin.entity.GoblinStoreOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;


@ApiModel(value = "GoblinOrderPreParam")
@Data
public class GoblinOrderPreParam implements Cloneable{

    @ApiModelProperty(required = false, value = "实际支付价格")
    private BigDecimal priceActual;

    @ApiModelProperty(required = true, value = "商铺名称")
    private String storeName;

    @ApiModelProperty(required = true, value = "sku名称")
    private String skuName;

    @ApiModelProperty(required = true, value = "总订单号")
    private String orderMasterCode;

    @ApiModelProperty(required = true, value = "订单id[逗号隔开]")
    private String orderIdList;

    @ApiModelProperty(required = true, value = "订单过期时间")
    private int expireTime;

    private String deviceFrom;
    private String authCode;
    private String payType;
    private String openId;
    private String returnUrl;
    private String showUrl;

    private GoblinStoreOrder storeOrder;
    private GoblinOrderAttr orderAttr;
    private List<GoblinOrderSku> orderSkuList;

    private static final GoblinOrderPreParam obj = new GoblinOrderPreParam();

    public static GoblinOrderPreParam getNew() {
        try {
            return (GoblinOrderPreParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinOrderPreParam();
        }
    }
}
