package com.liquidnet.client.admin.web.controller.zhengzai.kylin;


import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinRecommendActiveRelationServiceImpl;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinRecommendActiveServiceImpl;
import com.liquidnet.service.kylin.dto.param.KylinRecommendActiveParam;
import com.liquidnet.service.kylin.entity.KylinRecommendActive;
import com.liquidnet.service.kylin.entity.KylinRecommendActiveRelation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 推荐活动表 前端控制器
 * </p>
 */
@Api(tags = "推荐活动controller")
@RestController
@RequestMapping("/kylin-recommend-active")
public class KylinRecommendActiveController {
    @Autowired
    private KylinRecommendActiveServiceImpl kylinRecommendActiveService;
    @Autowired
    private KylinRecommendActiveRelationServiceImpl kylinRecommendActiveRelationService;

    @PostMapping("addKylinRecommendActive")
    @ApiOperation(value = "增加活动")
    @ResponseBody
    public AjaxResult addKylinRecommendActive(@RequestBody KylinRecommendActiveParam kylinRecommendActiveParam) {
        KylinRecommendActive kylinRecommendActive=new KylinRecommendActive();
        BeanUtils.copyProperties(kylinRecommendActiveParam, kylinRecommendActive);
        List<KylinRecommendActiveRelation> list=new ArrayList<KylinRecommendActiveRelation>();
        kylinRecommendActiveParam.getList().forEach(r->{
            KylinRecommendActiveRelation kylinRecommendActiveRelation=new KylinRecommendActiveRelation();
            BeanUtils.copyProperties(r, kylinRecommendActiveRelation);
            list.add(kylinRecommendActiveRelation);
        });
        kylinRecommendActiveService.addKylinRecommendActive(kylinRecommendActive,list);
        return AjaxResult.success("操作成功", "");
    }
    @PostMapping("updateKylinRecommendActive")
    @ApiOperation(value = "修改活动")
    @ResponseBody
    public AjaxResult updateKylinRecommendActive(@RequestBody KylinRecommendActiveParam kylinRecommendActiveParam) {
        KylinRecommendActive kylinRecommendActive=new KylinRecommendActive();
        BeanUtils.copyProperties(kylinRecommendActiveParam, kylinRecommendActive);
        kylinRecommendActiveService.updateKylinRecommendActive(kylinRecommendActive);
        return AjaxResult.success("操作成功", "");
    }
}
