package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.entity.KylinRecommendActive;
import com.liquidnet.service.kylin.entity.KylinRecommendActiveRelation;
import com.liquidnet.service.kylin.mapper.KylinRecommendActiveMapper;
import com.liquidnet.service.kylin.mapper.KylinRecommendActiveRelationMapper;
import com.liquidnet.service.kylin.service.admin.IKylinRecommendActiveService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 推荐活动表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-07-27
 */
@Service
public class KylinRecommendActiveServiceImpl extends ServiceImpl<KylinRecommendActiveMapper, KylinRecommendActive> implements IKylinRecommendActiveService {
    @Autowired
    private KylinRecommendActiveMapper kylinRecommendActiveMapper;
    @Autowired
    private KylinRecommendActiveRelationMapper kylinRecommendActiveRelationMapper;

    @Override
    public boolean addKylinRecommendActive(KylinRecommendActive kylinRecommendActive, List<KylinRecommendActiveRelation> kylinRecommendActiveRelations) {
        //生成id
        kylinRecommendActive.setRecommendId(IDGenerator.nextSnowId());
        kylinRecommendActive.setCreatedAt(LocalDateTime.now());
        kylinRecommendActive.setUpdatedAt(LocalDateTime.now());
        kylinRecommendActive.setDelTag(0);
        kylinRecommendActiveMapper.insert(kylinRecommendActive);
        //保存推荐活动关系
        kylinRecommendActiveRelations.forEach(r->{
            kylinRecommendActive.setCreatedAt(LocalDateTime.now());
            kylinRecommendActive.setUpdatedAt(LocalDateTime.now());
            r.setRecommendActiveId(kylinRecommendActive.getRecommendId());
            kylinRecommendActiveRelationMapper.insert(r);
        });
        return true;
    }

    @Override
    public boolean updateKylinRecommendActive(KylinRecommendActive kylinRecommendActive) {
        kylinRecommendActiveMapper.updateById(kylinRecommendActive);
        return true;
    }
}
