package com.liquidnet.service.kylin.dto.param;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.liquidnet.service.kylin.entity.KylinFieldStatus;
import com.liquidnet.service.kylin.entity.KylinFields;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * 修改场地全部显示数据参数
 */
@Data
public class FieldsAuditParam  implements Serializable {
    @ApiModelProperty(value = "场地主键")
    private String fieldsId;

    @ApiModelProperty(value = "认证状态 1已认证 2被拒绝", example = "1")
    private Integer validStatus;

    @ApiModelProperty(value = "审核状态 0待审核 1已审核 2被拒绝", example = "0",hidden = true)
    private Integer changeStatus;

    @ApiModelProperty(value = "拒绝理由", example = "")
    private String refuseMessage;

    @ApiModelProperty(example = "",hidden = true)
    private String updatedAt;

    @JsonIgnore
    public KylinFieldStatus getFieldStatus() {
        KylinFieldStatus fieldStatus = new KylinFieldStatus();
        fieldStatus.setValidStatus(validStatus);
        fieldStatus.setChangeStatus(changeStatus);
        return fieldStatus;
    }

    @JsonIgnore
    public KylinFields getFields() {
        KylinFields fields = new KylinFields();
        fields.setRefuseMessage(refuseMessage);
        return fields;
    }
}