package com.liquidnet.service.consumer.base.receiver;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.chime.vo.mongo.ChimeUserOperLogVo;
import com.liquidnet.service.consumer.base.util.ChimeDataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.stereotype.Component;

import java.util.HashMap;

@Slf4j
@Component
public class ConsumerChimeUserOperationDislikeReceiver extends AbstractBizRedisReceiver {
    @Autowired
    private ChimeDataUtils chimeDataUtils;

    @Override
    protected boolean consumerMessageHandler(String msg) {
        boolean aBoolean = false;
        try {
            ChimeUserOperLogVo textMessage = JsonUtils.fromJson(msg, ChimeUserOperLogVo.class);
            if (textMessage == null) {
                aBoolean = true;
            } else {
                //执行计数
                chimeDataUtils.updateChimeUser(textMessage);
                //创建操作日志
                chimeDataUtils.createUserOperLog(textMessage);
                aBoolean = true;
            }
        } catch (Exception e) {
            log.error("CONSUMER MSG EX_HANDLE ==> [{}]:{}", this.getRedisStreamKey(), msg, e);
        } finally {
            if (!aBoolean) {
                HashMap<String, String> map = CollectionUtil.mapStringString();
                map.put("message", msg);
                stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(map).withStreamKey(this.getRedisStreamKey()));
            }
        }
        return aBoolean;
    }

    @Override
    protected String getRedisStreamKey() {
        return MQConst.ChimeQueue.USER_OPERATION_DISLIKE.getKey();
    }

    @Override
    protected String getRedisStreamGroup() {
        return MQConst.ChimeQueue.USER_OPERATION_DISLIKE.getGroup();
    }
}
