package com.liquidnet.service.sweet.param;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 * 失物招领信息查询参数
 *
 * @author liquidnet
 * @since 2025-01-18
 */
@Data
@ApiModel("失物招领信息查询参数")
public class SweetLostFoundItemParam implements Serializable {

    @ApiModelProperty("主键ID 编辑填写")
    @NotNull(message = "ID不能为空", groups = ValidationGroups.Update.class)
    private Long id;

    @ApiModelProperty("演出ID")
    @NotBlank(message = "演出ID不能为空")
    private String performanceId;

    @ApiModelProperty("物品类型：1-证件卡类 2-3C数码类 3-服饰类 4-其他")
    @NotNull(message = "物品类型不能为空")
    private Integer itemType;

    @ApiModelProperty("拾捡地：1-音乐节现场 2-其他")
    @NotNull(message = "拾捡地不能为空")
    private Integer pickupLocation;

    @ApiModelProperty("捡拾日期")
    @NotNull(message = "捡拾日期不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date pickupDate;

    @ApiModelProperty("物品描述，最多120字")
    @NotBlank(message = "物品描述不能为空")
    private String description;

    @ApiModelProperty("物品图片URL")
    @NotBlank(message = "物品图片URL不能为空")
    private String itemImage;

}