/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.handshake;

import com.taobao.api.internal.toplink.embedded.websocket.HttpHeader;
import com.taobao.api.internal.toplink.embedded.websocket.util.StringUtil;
import java.nio.ByteBuffer;

public class HttpResponseHeaderParser {
    private HttpHeader responseHeader = new HttpHeader();
    private boolean complete = false;

    public void parse(ByteBuffer buffer) {
        if (this.complete) {
            throw new IllegalStateException("Parser already parse completed");
        }
        do {
            String[] keyValue;
            String line;
            if ((line = StringUtil.readLine(buffer)) == null) {
                return;
            }
            if (line.indexOf(58) > 0 && (keyValue = line.split(":", 2)).length > 1) {
                this.responseHeader.addHeader(keyValue[0].trim(), keyValue[1].trim());
            }
            if ("\r\n".compareTo(line) != 0) continue;
            this.complete = true;
            return;
        } while (buffer.hasRemaining());
    }

    public boolean isCompleted() {
        return this.complete;
    }

    public HttpHeader getResponseHeader() {
        return this.responseHeader;
    }
}

