package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinStoreConfigService;
import com.liquidnet.common.exception.LiquidnetServiceException;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreConfigVo;
import com.liquidnet.service.goblin.entity.GoblinStoreConfig;
import com.liquidnet.service.goblin.mapper.GoblinStoreConfigMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 店铺设置 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Slf4j
@Service
public class GoblinStoreConfigServiceImpl extends ServiceImpl<GoblinStoreConfigMapper, GoblinStoreConfig> implements IGoblinStoreConfigService {

    @Override
    public List<GoblinStoreConfigVo> initStoreConfigs(String storeId) {
        List<GoblinStoreConfig> initStoreConfigList = this.list(Wrappers.lambdaQuery(GoblinStoreConfig.class).eq(GoblinStoreConfig::getStoreId, "0"));
        if (!CollectionUtils.isEmpty(initStoreConfigList)) {
            List<GoblinStoreConfigVo> initStoreConfigVoList = new ArrayList<>();
            String operator = "system";
            LocalDateTime now = LocalDateTime.now();
            initStoreConfigList.forEach(c -> {
                c.setStoreId(storeId);
                c.setCreatedBy(operator);
                c.setCreatedAt(now);
                initStoreConfigVoList.add(GoblinStoreConfigVo.getNew().copy(c));
            });
            if (this.saveBatch(initStoreConfigList)) {
                return initStoreConfigVoList;
            }
        }
        log.warn("店铺审核:初始化配置失败:店铺初始配置为空或数据存储失败[initStoreConfigList={}]", JsonUtils.toJson(initStoreConfigList));
        throw new LiquidnetServiceException();
    }
}
