package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 电子宣传手册商铺表
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetManualShopFive implements Serializable,Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * manual_shop_id
     */
    private String manualShopId;

    /**
     * 电子宣传手册id
     */
    private String manualId;

    /**
     * 商家名称
     */
    private String title;

    /**
     * 商家图片
     */
    private String picUrl;

    /**
     * 商家介绍
     */
    private String describes;

    /**
     * 1吃喝 2玩乐
     */
    private Integer type;

    /**
     * 0不推荐 1推荐
     */
    private Integer isRecommend;

    /**
     * 排序字段 数字越大越靠前
     */
    private Integer sort;

    /**
     * 0关闭 1开启
     */
    private Integer status;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetManualShopFive obj = new SweetManualShopFive();
    public static SweetManualShopFive getNew() {
        try {
            return (SweetManualShopFive) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetManualShopFive();
        }
    }
}
