package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.sweet.entity.SweetLostFoundAdmin;
import com.liquidnet.service.sweet.mapper.SweetLostFoundAdminMapper;
import com.liquidnet.service.sweet.param.SweetLostFoundAdminParam;
import com.liquidnet.service.sweet.service.ISweetLostFoundAdminService;
import com.liquidnet.service.sweet.vo.SweetLostFoundAdminVo;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 失物招领管理员服务实现类
 *
 * @author liquidnet
 * @since 2025-01-18
 */
@Service
public class SweetLostFoundAdminServiceImpl extends ServiceImpl<SweetLostFoundAdminMapper, SweetLostFoundAdmin> implements ISweetLostFoundAdminService {

    @Override
    public boolean addAdmin(SweetLostFoundAdminParam admin) {
        SweetLostFoundAdmin foundAdmin = SweetLostFoundAdmin.getNew();
        foundAdmin.setAdminId(IDGenerator.nextSnowId());
        foundAdmin.setPhone(admin.getPhone());
        foundAdmin.setName(admin.getName());
        foundAdmin.setPermissionType(admin.getPermissionType());
        foundAdmin.setAuthScope(admin.getAuthScope());
        foundAdmin.setPerformanceId(admin.getPerformanceId());
        return baseMapper.insert(foundAdmin) > 0;
    }

    @Override
    public boolean editAdmin(SweetLostFoundAdminParam admin) {
        SweetLostFoundAdmin foundAdmin = SweetLostFoundAdmin.getNew();
        foundAdmin.setId(admin.getId());
        foundAdmin.setPhone(admin.getPhone());
        foundAdmin.setName(admin.getName());
        foundAdmin.setPermissionType(admin.getPermissionType());
        foundAdmin.setAuthScope(admin.getAuthScope());
        foundAdmin.setPerformanceId(admin.getPerformanceId());
        return baseMapper.updateById(foundAdmin) > 0;
    }

    @Override
    public boolean deleteAdmin(Long id) {
        // 检查管理员是否存在
        SweetLostFoundAdmin admin = baseMapper.selectById(id);
        if (admin == null) {
            return false;
        }

        // 逻辑删除：更新is_deleted字段为1
        admin.setIsDeleted(1);
        return baseMapper.updateById(admin) > 0;
    }

    @Override
    public SweetLostFoundAdminVo getAdminDetail(Long id) {
        SweetLostFoundAdmin admin = baseMapper.selectById(id);
        if (admin == null || admin.getIsDeleted() == 1) {
            return null;
        }

        SweetLostFoundAdminVo vo = new SweetLostFoundAdminVo();
        BeanUtils.copyProperties(admin, vo);
        return vo;
    }

    @Override
    public List<SweetLostFoundAdminVo> getAdminList(String performanceId) {
        // 构建查询条件
        QueryWrapper<SweetLostFoundAdmin> queryWrapper = new QueryWrapper<>();

        // 过滤逻辑删除的记录
        queryWrapper.eq("is_deleted", 0);

        // 查询条件：performanceId = 指定演出ID OR authScope = 2(全站)
        if (performanceId != null && !performanceId.trim().isEmpty()) {
            queryWrapper.and(wrapper ->
                    wrapper.eq("performance_id", performanceId.trim())
                            .or()
                            .eq("auth_scope", 2)
            );
        } else {
            // 如果没有performanceId，只查authScope=2的全站管理员
            queryWrapper.eq("auth_scope", 2);
        }

        // 默认按创建时间降序
        queryWrapper.orderByDesc("create_time");

        // 执行查询
        List<SweetLostFoundAdmin> adminList = baseMapper.selectList(queryWrapper);

        // 转换为VO对象
        List<SweetLostFoundAdminVo> voList = adminList.stream()
                .map(admin -> {
                    SweetLostFoundAdminVo vo = new SweetLostFoundAdminVo();
                    BeanUtils.copyProperties(admin, vo);
                    return vo;
                })
                .collect(Collectors.toList());

        return voList;
    }
}