package com.liquidnet.service.adam.dto;

import com.liquidnet.service.adam.dto.vo.AdamTagParentVo;
import com.liquidnet.service.adam.dto.vo.AdamTagVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel(value = "AdamUserInfoParam", description = "个人资料编辑参数")
@Data
public class AdamUserInfoParam implements java.io.Serializable {
    private static final long serialVersionUID = -1084524066864012398L;
    @ApiModelProperty(position = 11, required = true, value = "头像[255]", example = "http://pic.zhengzai.tv/default/avatar.png")
    private String avatar;
    @ApiModelProperty(position = 12, required = true, value = "背景[255]", example = "https://img.zhengzai.tv/files/2021/01/13/5ffeab3584b7d.png")
    private String background;
    @ApiModelProperty(position = 13, required = true, value = "昵称[32]", example = "Swagger")
    private String nickname;
    @ApiModelProperty(position = 14, required = true, value = "性别[32]", example = "{\"val\":\"MS00\",\"desc\":\"其他性别\"}")
    private AdamTagVo sex;
    @ApiModelProperty(position = 15, required = true, value = "生日[YYYY-MM-DD]", example = "2021-05-17")
    private String birthday;
    @ApiModelProperty(position = 16, required = true, value = "常住地/区域[100]", example = "北京 北京市 朝阳区")
    private String area;
    @ApiModelProperty(position = 17, required = true, value = "签名[255]", example = "...................")
    private String signature;
    @ApiModelProperty(position = 18, required = true, value = "标签[500]", example = "[{\"val\":\"MMS01\",\"desc\":\"民歌\",\"tagVos\":[{\"val\":\"MMS0101\",\"desc\":\"A\"},{\"val\":\"MMS0102\",\"desc\":\"B\"}]},{\"val\":\"MMS02\",\"desc\":\"house\",\"tagVos\":[{\"val\":\"MMS0201\",\"desc\":\"C\"}]}]")
    private List<AdamTagParentVo> tagMe;
}
