package com.liquidnet.service.adam.service;

import com.liquidnet.service.adam.dto.AdamThirdPartParam;
import com.liquidnet.service.adam.dto.vo.AdamThirdPartInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.entity.AdamUser;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * <p>
 * 用户 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-10
 */
public interface IAdamUserService extends IService<AdamUser> {

    String queryUidByRedis(String mobile);

    String queryUidByRedis(String openId, String platform);

    AdamUserInfoVo queryByUid(String uid);

    /**
     * 手机号注册
     *
     * @param mobile
     * @return AdamUserInfoVo
     */
    AdamUserInfoVo register(String mobile);

    /**
     * 第三方账号注册
     *
     * @param param
     * @return AdamUserInfoVo
     */
    AdamUserInfoVo register(AdamThirdPartParam param);

    /**
     * 第三方账号绑定（不存在已绑定账号）
     *
     * @param uid
     * @param param
     */
    void bindTpa(String uid, AdamThirdPartParam param);

    /**
     * 第三方账号绑定（存在已绑定账号）
     *
     * @param bindUid
     * @param unBindUid
     * @param param
     * @return
     */
    List<AdamThirdPartInfoVo> bindTpaForce(String bindUid, String unBindUid, AdamThirdPartParam param);

    /**
     * 第三方账号解绑
     *
     * @param uid
     * @param platform
     * @return List<AdamThirdPartInfoVo>
     */
    List<AdamThirdPartInfoVo> unBindTpa(String uid, String platform);

    void close(String uid);
}
