package com.liquidnet.service.bank.currencycloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.currencycloud.client.CurrencyCloudClient;
import com.currencycloud.client.exception.ApiException;
import com.currencycloud.client.model.Balance;
import com.liquidnet.service.bank.common.BankErrorCode;
import com.liquidnet.service.bank.common.BankResultDto;
import com.liquidnet.service.bank.currencycloud.entity.BankCcBalance;
import com.liquidnet.service.bank.currencycloud.mapper.BankCcBalanceMapper;
import com.liquidnet.service.bank.currencycloud.service.IBankCcBalanceService;
import com.liquidnet.service.feign.adam.api.account.FeignAdamAccountWalletClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author lightnet
 * @since 2020-09-08
 */
@Slf4j
@Service("bankCcBalanceService")
public class BankCcBalanceServiceImpl implements IBankCcBalanceService {

    @Autowired
    CurrencyCloudClient currencyCloudClient;

    @Autowired
    BankCcBalanceMapper bankCcBalanceMapper;

    @Autowired
    FeignAdamAccountWalletClient feignAdamAccountWalletClient;

    @Override
    public BankResultDto<BankCcBalance> retrieveBalance(String currency, String contactId) {

        String logFx = contactId + ",cc retrieve balance,currency=[" + currency + "]";
        try {
            BankCcBalance bankCcBalance = new BankCcBalance();
            Runnable runnable = () -> {
                Balance balance = currencyCloudClient.retrieveBalance(currency);
                log.info(logFx + "response,balance=[{}]", balance.toString());

                BeanUtils.copyProperties(balance, bankCcBalance);

                BankCcBalance selectBalance = bankCcBalanceMapper.selectById(balance.getId());
                if (selectBalance == null) {
                    // 持久化数据库
                    bankCcBalance.setCreateTime(LocalDateTime.now());
                    bankCcBalanceMapper.insert(bankCcBalance);
                } else {
                    bankCcBalance.setUpdateTime(LocalDateTime.now());
                    bankCcBalanceMapper.updateById(bankCcBalance);
                }
//                ResponseDto responseDto = feignAdamAccountWalletClient.pushNotifyBalance(bankCcBalance);
//                log.info(logFx + "push notify balance,responseDto=[{}]", JSON.toJSONString(responseDto));

            };
            currencyCloudClient.onBehalfOfDo(contactId, runnable);
            return BankResultDto.success(bankCcBalance);
        } catch (ApiException e) {
            log.error(logFx + "api eroor, errorCode=[{}],errors=[{}]", e.getErrorCode(), e.getErrors());
            return BankResultDto.failure(e.getErrorCode(), e.getMessage());
        } catch (Exception e) {
            log.error(logFx + "exception eroor:[{}]", JSON.toJSONString(e));
            return BankResultDto.failure(BankErrorCode.BANK_CC_001001);
        }
    }

}
