package com.liquidnet.service.goblin.service.impl;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.goblin.constant.GoblinStatusConst;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreCouponVo;
import com.liquidnet.service.goblin.service.GoblinCouponService;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

public class GoblinCouponImpl implements GoblinCouponService {

    @Autowired
    GoblinRedisUtils redisUtils;

    @Override
    public ArrayList<String> getSpuType(String spuId, String storeId) {
        ArrayList<String> returnList = CollectionUtil.arrayListString();
        String pre = GoblinStatusConst.MarketPreStatus.getPre(spuId);
        if (pre != null) {
            spuId = spuId.split(pre)[0];
        }
        List<GoblinStoreCouponVo> listVo = redisUtils.getGoodsMarketsForCoupon(spuId, storeId);
        for (GoblinStoreCouponVo vo : listVo) {
            if (!returnList.contains(vo.getType()) && LocalDateTime.now().isAfter(vo.getStartTime()) && LocalDateTime.now().isBefore(vo.getEndTime())) {
                returnList.add(vo.getType());
            }
        }
        return returnList;
    }

    @Override
    public ArrayList<GoblinStoreCouponVo> getSpuByType(String spuId, String storeId, String type) {
        ArrayList<GoblinStoreCouponVo> returnList = ObjectUtil.getGoblinStoreCouponVoArrayList();
        String pre = GoblinStatusConst.MarketPreStatus.getPre(spuId);
        if (pre != null) {
            spuId = spuId.split(pre)[0];
        }
        List<GoblinStoreCouponVo> listVo = redisUtils.getGoodsMarketsForCoupon(spuId, storeId);
        for (GoblinStoreCouponVo vo : listVo) {
            if (vo.getType().equals(type) && LocalDateTime.now().isAfter(vo.getStartTime()) && LocalDateTime.now().isBefore(vo.getEndTime())) {
                vo.setStock(null);
                returnList.add(vo);
            }
        }
        return returnList;
    }

    @Override
    public ArrayList<Boolean> receiveCoupon(String storeCouponId, Integer number) {
        return null;
    }
}
