package com.liquidnet.client.admin.zhengzai.kylin.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.client.admin.common.core.domain.BaseEntity;

/**
 * 演出对象 kylin_performances
 * 
 * @author ruoyi
 * @date 2021-05-24
 */
public class KylinPerformances extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long mid;

    /** performances_id */
    @Excel(name = "performances_id")
    private String performancesId;

    /** 演出名称 */
    @Excel(name = "演出名称")
    private String title;

    /** 1音乐节 2演唱会 3小型演出 4展览 6舞台剧 101音乐节 102小型演出(livehouse演出) 103巡演 */
    @Excel(name = "1音乐节 2演唱会 3小型演出 4展览 6舞台剧 101音乐节 102小型演出(livehouse演出) 103巡演")
    private Integer type;

    /** 演出海报 */
    @Excel(name = "演出海报")
    private String imgPoster;

    /** 省id */
    @Excel(name = "省id")
    private String provinceId;

    /** 省名称 */
    @Excel(name = "省名称")
    private String provinceName;

    /** 城市id */
    @Excel(name = "城市id")
    private Long cityId;

    /** 城市名称 */
    @Excel(name = "城市名称")
    private String cityName;

    /** 县id */
    @Excel(name = "县id")
    private Long districtId;

    /** 县名称 */
    @Excel(name = "县名称")
    private String districtName;

    /** 批文地址 */
    @Excel(name = "批文地址")
    private String approvalUrl;

    /** 演出公告 */
    @Excel(name = "演出公告")
    private String notice;

    /** 主办方id */
    @Excel(name = "主办方id")
    private String sponsorId;

    /** 主办方类型 */
    @Excel(name = "主办方类型")
    private String sponsorType;

    /** 主办方 */
    @Excel(name = "主办方")
    private String sponsor;

    /** 联系人 */
    @Excel(name = "联系人")
    private String contacts;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String mobile;

    /** 演出简介 */
    @Excel(name = "演出简介")
    private String describes;

    /** 演出详情 */
    @Excel(name = "演出详情")
    private String details;

    /** 购票须知 */
    @Excel(name = "购票须知")
    private String noticeImage;

    /** 演出开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "演出开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date timeStart;

    /** 演出结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "演出结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date timeEnd;

    /** 提审时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "提审时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date auditTime;

    /** 拒绝理由 */
    @Excel(name = "拒绝理由")
    private String rejectTxt;

    /** 权重 高则在上 */
    @Excel(name = "权重 高则在上")
    private Long sort;

    /** comment */
    @Excel(name = "comment")
    private String comment;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdAt;

    /** 修改时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "修改时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date updatedAt;

    public void setMid(Long mid) 
    {
        this.mid = mid;
    }

    public Long getMid() 
    {
        return mid;
    }
    public void setPerformancesId(String performancesId) 
    {
        this.performancesId = performancesId;
    }

    public String getPerformancesId() 
    {
        return performancesId;
    }
    public void setTitle(String title) 
    {
        this.title = title;
    }

    public String getTitle() 
    {
        return title;
    }
    public void setType(Integer type) 
    {
        this.type = type;
    }

    public Integer getType() 
    {
        return type;
    }
    public void setImgPoster(String imgPoster) 
    {
        this.imgPoster = imgPoster;
    }

    public String getImgPoster() 
    {
        return imgPoster;
    }
    public void setProvinceId(String provinceId) 
    {
        this.provinceId = provinceId;
    }

    public String getProvinceId() 
    {
        return provinceId;
    }
    public void setProvinceName(String provinceName) 
    {
        this.provinceName = provinceName;
    }

    public String getProvinceName() 
    {
        return provinceName;
    }
    public void setCityId(Long cityId) 
    {
        this.cityId = cityId;
    }

    public Long getCityId() 
    {
        return cityId;
    }
    public void setCityName(String cityName) 
    {
        this.cityName = cityName;
    }

    public String getCityName() 
    {
        return cityName;
    }
    public void setDistrictId(Long districtId) 
    {
        this.districtId = districtId;
    }

    public Long getDistrictId() 
    {
        return districtId;
    }
    public void setDistrictName(String districtName) 
    {
        this.districtName = districtName;
    }

    public String getDistrictName() 
    {
        return districtName;
    }
    public void setApprovalUrl(String approvalUrl) 
    {
        this.approvalUrl = approvalUrl;
    }

    public String getApprovalUrl() 
    {
        return approvalUrl;
    }
    public void setNotice(String notice) 
    {
        this.notice = notice;
    }

    public String getNotice() 
    {
        return notice;
    }
    public void setSponsorId(String sponsorId) 
    {
        this.sponsorId = sponsorId;
    }

    public String getSponsorId() 
    {
        return sponsorId;
    }
    public void setSponsorType(String sponsorType) 
    {
        this.sponsorType = sponsorType;
    }

    public String getSponsorType() 
    {
        return sponsorType;
    }
    public void setSponsor(String sponsor) 
    {
        this.sponsor = sponsor;
    }

    public String getSponsor() 
    {
        return sponsor;
    }
    public void setContacts(String contacts) 
    {
        this.contacts = contacts;
    }

    public String getContacts() 
    {
        return contacts;
    }
    public void setMobile(String mobile) 
    {
        this.mobile = mobile;
    }

    public String getMobile() 
    {
        return mobile;
    }
    public void setDescribes(String describes) 
    {
        this.describes = describes;
    }

    public String getDescribes() 
    {
        return describes;
    }
    public void setDetails(String details) 
    {
        this.details = details;
    }

    public String getDetails() 
    {
        return details;
    }
    public void setNoticeImage(String noticeImage) 
    {
        this.noticeImage = noticeImage;
    }

    public String getNoticeImage() 
    {
        return noticeImage;
    }
    public void setTimeStart(Date timeStart) 
    {
        this.timeStart = timeStart;
    }

    public Date getTimeStart() 
    {
        return timeStart;
    }
    public void setTimeEnd(Date timeEnd) 
    {
        this.timeEnd = timeEnd;
    }

    public Date getTimeEnd() 
    {
        return timeEnd;
    }
    public void setAuditTime(Date auditTime) 
    {
        this.auditTime = auditTime;
    }

    public Date getAuditTime() 
    {
        return auditTime;
    }
    public void setRejectTxt(String rejectTxt) 
    {
        this.rejectTxt = rejectTxt;
    }

    public String getRejectTxt() 
    {
        return rejectTxt;
    }
    public void setSort(Long sort) 
    {
        this.sort = sort;
    }

    public Long getSort() 
    {
        return sort;
    }
    public void setComment(String comment) 
    {
        this.comment = comment;
    }

    public String getComment() 
    {
        return comment;
    }
    public void setCreatedAt(Date createdAt) 
    {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() 
    {
        return createdAt;
    }
    public void setUpdatedAt(Date updatedAt) 
    {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() 
    {
        return updatedAt;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("mid", getMid())
            .append("performancesId", getPerformancesId())
            .append("title", getTitle())
            .append("type", getType())
            .append("imgPoster", getImgPoster())
            .append("provinceId", getProvinceId())
            .append("provinceName", getProvinceName())
            .append("cityId", getCityId())
            .append("cityName", getCityName())
            .append("districtId", getDistrictId())
            .append("districtName", getDistrictName())
            .append("approvalUrl", getApprovalUrl())
            .append("notice", getNotice())
            .append("sponsorId", getSponsorId())
            .append("sponsorType", getSponsorType())
            .append("sponsor", getSponsor())
            .append("contacts", getContacts())
            .append("mobile", getMobile())
            .append("describes", getDescribes())
            .append("details", getDetails())
            .append("noticeImage", getNoticeImage())
            .append("timeStart", getTimeStart())
            .append("timeEnd", getTimeEnd())
            .append("auditTime", getAuditTime())
            .append("rejectTxt", getRejectTxt())
            .append("sort", getSort())
            .append("comment", getComment())
            .append("createdAt", getCreatedAt())
            .append("updatedAt", getUpdatedAt())
            .toString();
    }
}
