package com.liquidnet.service.executor.main.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.liquidnet.service.account.wallet.dto.WalletCalTransBalanceParam;
import com.liquidnet.service.account.wallet.dto.base.WalletCallResult;
import com.liquidnet.service.feign.account.api.FeignAccountTaskClient;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/**
 * ExecutorAccountHandler.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/11/4
 */
@Component
public class ExecutorAccountHandler {
    private static final Logger log = LoggerFactory.getLogger(ExecutorAccountHandler.class);
    @Autowired
    private FeignAccountTaskClient accountTaskClient;

    @XxlJob(value = "sev-account:calTransBalance")
    public ReturnT<String> calTransBalance(String param) {
        XxlJobLogger.log("start:liquidnet.calTransBalance:[{}]", param);

        Integer limitedSize = null;
        if (!StringUtils.isEmpty(param)) {
            JSONObject jsonParam = JSON.parseObject(param);
            limitedSize = jsonParam.getInteger("lSize");
        }
        limitedSize = null == limitedSize ? 1000 : limitedSize;

        WalletCalTransBalanceParam calTransBalanceParam = new WalletCalTransBalanceParam();
        calTransBalanceParam.setChannelId("50001");
        calTransBalanceParam.setBizType("000");
        calTransBalanceParam.setLimitedSize(limitedSize);
        WalletCallResult<?> result = accountTaskClient.calTransBalance(calTransBalanceParam);
        XxlJobLogger.log("end:liquidnet.calTransBalance:[{}]",JSON.toJSONString(result));
        return ReturnT.SUCCESS;
    }
}
