package com.liquidnet.service.galaxy.biz;

import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.bo.GalaxyNftOrderBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesNftInfoBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyUserInfoBo;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishAndBuyReqDto;
import com.liquidnet.service.galaxy.dto.vo.mongo.GalaxyNftOrderFailLogVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyCommonBiz
 * @Package com.liquidnet.service.galaxy.router.strategy.biz
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/23 11:20
 */
@Slf4j
@Component
public class GalaxyBeanTransferBiz {
    @Autowired
    private ZxlnftConfig zxlnftConfig;

    public GalaxyNftOrderBo buildNftOrderBo(String nftOrderPayId, GalaxyUserInfoBo userInfoBo, GalaxySeriesNftInfoBo seriesNftInfoBo){
        GalaxyNftOrderBo nftOrderBo = GalaxyNftOrderBo.getNew();
        nftOrderBo.setUserId(userInfoBo.getUserId());
        nftOrderBo.setSkuId(seriesNftInfoBo.getSkuId());
        nftOrderBo.setSeriesName(seriesNftInfoBo.getSeriesName());
        nftOrderBo.setSeriesId(seriesNftInfoBo.getSeriesId());
        nftOrderBo.setSeriesCode(seriesNftInfoBo.getSeriesCode());
        nftOrderBo.setNftOrderPayId(nftOrderPayId);
        nftOrderBo.setNftId(null);
        nftOrderBo.setNftPrice(seriesNftInfoBo.getSellCount().longValue());
        nftOrderBo.setNftPublishTaskId(null);
        nftOrderBo.setNftPublishFromAddress(zxlnftConfig.getNftPlatformAddress());
        nftOrderBo.setNftPublishToAddress("NFT");
        nftOrderBo.setNftPublishChainTimestamp(null);
        nftOrderBo.setNftPublishStatus(GalaxyEnum.TaskStatusEnum.INIT.getCode());
        nftOrderBo.setNftPublishTradeHash(null);
        nftOrderBo.setNftBuyTaskId(null);
        nftOrderBo.setNftBuyFromAddress(zxlnftConfig.getNftPlatformAddress());
        nftOrderBo.setNftBuyToAddress(userInfoBo.getBlockChainAddress());
        nftOrderBo.setNftBuyChainTimestamp(null);
        nftOrderBo.setNftBuyStatus(GalaxyEnum.TaskStatusEnum.INIT.getCode());
        nftOrderBo.setNftBuyTradeHash(null);
        nftOrderBo.setNftBuyPayTaskId(null);
        nftOrderBo.setRouterType(seriesNftInfoBo.getRouterType());
        nftOrderBo.setCreatedAt(LocalDateTime.now());
        nftOrderBo.setUpdatedAt(null);
        return nftOrderBo;
    }

    /**
     *
     * @param reqDto
     * @param userInfoBo
     * @param seriesNftInfoBo
     * @return
     */
    public GalaxyNftOrderFailLogVo buildNftOrderFailLogVo(GalaxyEnum.TradeTypeEnum tradeTypeEnum,GalaxyNftPublishAndBuyReqDto reqDto
            ,GalaxyEnum.OrderDealWithStatusEnum orderDealWithStatus,String failDesc,String failDescSecond,GalaxyUserInfoBo userInfoBo, GalaxySeriesNftInfoBo seriesNftInfoBo, GalaxyNftOrderBo nftOrderBo){
        GalaxyNftOrderFailLogVo nftOrderFailLogVo = GalaxyNftOrderFailLogVo.getNew();
        nftOrderFailLogVo.setNftOrderPayId(reqDto.getNftOrderPayId());

        if(StringUtil.isNotNull(seriesNftInfoBo)){
            nftOrderFailLogVo.setUserId(seriesNftInfoBo.getSkuId());
            nftOrderFailLogVo.setNftName(seriesNftInfoBo.getNftName());
            nftOrderFailLogVo.setSeriesName(seriesNftInfoBo.getSeriesName());
            nftOrderFailLogVo.setSeriesId(seriesNftInfoBo.getSeriesId());
            nftOrderFailLogVo.setSeriesCode(seriesNftInfoBo.getSeriesCode());
        }

        if(StringUtil.isNotNull(nftOrderBo)){
            nftOrderFailLogVo.setNftId(nftOrderBo.getNftId());
            if(tradeTypeEnum.getCode().equalsIgnoreCase(GalaxyEnum.TradeTypeEnum.TRADE_PUBLISH.getCode())){
                nftOrderFailLogVo.setTaskId(nftOrderBo.getNftPublishTaskId());
            }else if(tradeTypeEnum.getCode().equalsIgnoreCase(GalaxyEnum.TradeTypeEnum.TRADE_BUY.getCode())){
                nftOrderFailLogVo.setTaskId(nftOrderBo.getNftBuyTaskId());
            }
        }
        nftOrderFailLogVo.setFailReasonDesc(failDesc);
        nftOrderFailLogVo.setFailReasonDescSecond(failDescSecond);
        nftOrderFailLogVo.setDealWithStatus(orderDealWithStatus.getCode());
        nftOrderFailLogVo.setTradeType(tradeTypeEnum.getCode());
        nftOrderFailLogVo.setRouterType(reqDto.getRouterType());
        nftOrderFailLogVo.setCreatedAt(LocalDateTime.now());
        nftOrderFailLogVo.setUpdatedAt(null);
        return nftOrderFailLogVo;
    }
}
