/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.channel.websocket;

import com.taobao.api.internal.toplink.Text;
import com.taobao.api.internal.toplink.channel.ChannelException;
import com.taobao.api.internal.toplink.channel.ChannelSender;
import com.taobao.api.internal.toplink.channel.ChannelTimeoutException;
import com.taobao.api.internal.toplink.channel.netty.NettyChannelSender;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;

public abstract class WebSocketChannelSender
extends NettyChannelSender {
    public static int MaxTotalPendingCount = 50000;
    public static AtomicInteger TotalPendingCount = new AtomicInteger();
    private AtomicInteger pendingCount = new AtomicInteger();
    private int maxPendingCount = 1000;
    private int timeout = 2000;

    public WebSocketChannelSender(Channel channel) {
        super(channel);
    }

    public void setMaxPendingCount(int value) {
        this.maxPendingCount = value;
    }

    public void setTimeoutMillis(int value) {
        this.timeout = value;
    }

    public int getPendingCount() {
        return this.pendingCount.get();
    }

    public void send(byte[] data, int offset, int length) throws ChannelException {
        ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])data, (int)offset, (int)length);
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(buffer);
        this.send((WebSocketFrame)frame, null);
    }

    public void send(ByteBuffer dataBuffer, ChannelSender.SendHandler sendHandler) throws ChannelException {
        ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((ByteBuffer)dataBuffer);
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(buffer);
        this.send((WebSocketFrame)frame, sendHandler);
    }

    public void close(String reason) {
        this.channel.write((Object)new CloseWebSocketFrame(1000, reason));
    }

    private void send(WebSocketFrame frame, final ChannelSender.SendHandler sendHandler) throws ChannelException {
        frame.setFinalFragment(true);
        final CountDownLatch latch = this.isHighwater() && this.timeout > 0 ? new CountDownLatch(1) : null;
        this.channel.write((Object)frame).addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                TotalPendingCount.decrementAndGet();
                WebSocketChannelSender.this.pendingCount.decrementAndGet();
                if (latch != null) {
                    latch.countDown();
                } else if (sendHandler != null) {
                    sendHandler.onSendComplete(future.isSuccess());
                }
            }
        });
        if (latch == null) {
            return;
        }
        try {
            try {
                if (!latch.await(this.timeout, TimeUnit.MILLISECONDS)) {
                    throw new ChannelTimeoutException(String.format(Text.WS_SEND_SYNC_TIMEOUT, this.timeout));
                }
                Object var6_4 = null;
            }
            catch (InterruptedException e) {
                throw new ChannelException(Text.WS_SEND_SYNC_ERROR, e);
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            throw throwable;
        }
    }

    private boolean isHighwater() {
        int self = this.pendingCount.incrementAndGet();
        int total = TotalPendingCount.incrementAndGet();
        return self > this.maxPendingCount || MaxTotalPendingCount > 0 && total > MaxTotalPendingCount;
    }
}

