package com.liquidnet.common.third.zxlnft.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 26.平台积分转移状态查询 GET请求方式
 * @class: PointTransferResultReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:41
 */
@Data
public class Nft026PointTransferResultReqDto implements Serializable {
    /**
     * 积分转移发起者的公钥，即平台公钥
     */
    private String platformPubKey;
    /**
     * 积分接收者地址-接口文档显示已废弃-待核实
     */
    private String toAddr;
    /**
     * 任务ID
     */
    private String taskId;
    private static final Nft026PointTransferResultReqDto obj = new Nft026PointTransferResultReqDto();
    private static final long serialVersionUID = 7704818772474489398L;

    public static Nft026PointTransferResultReqDto getNew() {
        try {
            return (Nft026PointTransferResultReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft026PointTransferResultReqDto();
        }
    }
}
