package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 轮播图 模型
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinBanners implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * banners_id
     */
    private String bannersId;

    /**
     * 标题
     */
    private String bannersName;

    /**
     * 封面图
     */
    private String coverImg;

    /**
     * 跳转类型
     */
    private Integer targetType;

    /**
     * 跳转目标id或者url
     */
    private String targetObj;
    private String targetObjName;

    /**
     * 是否上线展示 0下线 1上线
     */
    private Integer isOnline;

    /**
     * 上线开始时间
     */
    private String onlineStartTime;

    /**
     * 上线结束时间
     */
    private String onlineEndTime;

    /**
     * 推广类型 1全国 2省份
     */
    private Integer promotionType;

    /**
     * 排序权重
     */
    private Integer BannersSort;

    /**
     * 活动id
     */
    private String marketId;

    /**
     * 位置
     */
    @TableField(exist = false)
    private List<String> positionList;

    /**
     * 城市
     */
    @TableField(exist = false)
    private List<String> provincesList;

    /**
     * 是否删除 1正常 已删除
     */
    private Integer isDeleted;

    /**
     * 创建时间
     */
    private String createdAt;

    /**
     * 修改时间
     */
    private String updatedAt;

    /**
     * 演出ID
     */
    private String performanceId;

    /**
     * 演出名称
     */
    private String performanceName;

    private static final KylinBanners obj = new KylinBanners();

    public static KylinBanners getNew() {
        try {
            return (KylinBanners) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinBanners();
        }
    }
}
