package com.liquidnet.service.goblin.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinBraceletOrderVo;
import com.liquidnet.service.goblin.dto.vo.GoblinBraceletPayResultVo;
import com.liquidnet.service.goblin.entity.GoblinBraceletOrder;
import com.liquidnet.service.goblin.param.GoblinBraceletOrderPayParam;
import com.liquidnet.service.goblin.param.dougong.DougongSyncCallbackparam;

import java.util.List;

public interface IGoblinBraceletOrderService extends IService<GoblinBraceletOrder> {

    /**
     * 下单
     * @param payParam
     * @return
     */
    ResponseDto<GoblinBraceletPayResultVo> checkOrder(GoblinBraceletOrderPayParam payParam);

    /**
     * 校验订单状态
     * @param orderId
     * @return
     */
    ResponseDto<Integer> checkOrderResult(String orderId);

    /**
     * 斗拱支付回调
     * @return
     */
    ResponseDto<Boolean> dougongCallBack(DougongSyncCallbackparam callbackparam);

    /**
     * 获取订单列表
     * @return
     */
    List<GoblinBraceletOrderVo> getOrderList();
}
