package com.liquidnet.common.third.zxlnft.dto;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: PublishResultReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:46
 */
@Data
public class Nft035PublishResultRespDto implements Serializable {
    /**
     * nftId格式，发行人公钥hash_系列_系列索引id,申请多少个，最后一段计算出来即可，
     * 比如申请10个，nftIdBegin位xx_xx_1,那么就可以推导出x_xx_1到x_xx_10
     */
    private String nftIdBegin;
    /**
     * 标记任务状态，2：任务执行中 7：任务成功 10：任务失败
     */
    private Integer taskStatus;
    /**
     * 失败情况下会有提示信息
     */
    private String taskMsg;
    /**
     * 交易hash
     */
    private String txHash;
    /**
     * 链上交易时间戳
     */
    private Long chainTimestamp;

    private static final Nft035PublishResultRespDto obj = new Nft035PublishResultRespDto();
    public static Nft035PublishResultRespDto getNew() {
        try {
            return (Nft035PublishResultRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft035PublishResultRespDto();
        }
    }

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }
}
