package com.liquidnet.service.goblin.dto.vo;


import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import lombok.Data;

@Data
@HeadRowHeight(value = 20)//设置表头行高
@ColumnWidth(value = 15)//设置表头行宽
public class CodeExcelVo {

    @ExcelProperty(value = "兑换码", index = 0)
    private String code;

    @ExcelProperty(value = "藏品名称", index = 1)
    private String skuName;

    @ExcelProperty(value = "兑换开始时间", index = 2)
    private String excelStartTime;

    @ExcelProperty(value = "兑换结束时间", index = 3)
    private String excelStopTime;

    @ExcelProperty(value = "用户id", index = 4)
    private String redeemUid;

    @ExcelProperty(value = "状态", index = 5)
    private String state;

    private static final CodeExcelVo obj = new CodeExcelVo();

    public static CodeExcelVo getNew() {
        try {
            return (CodeExcelVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new CodeExcelVo();
        }
    }


}
