package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamDisposedUserVo", description = "想去的用户信息")
@Data
public class AdamDisposedUserVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 3222644230886542725L;
    @ApiModelProperty(position = 10, value = "用户ID[64]")
    private String uid;
    @ApiModelProperty(position = 11, value = "用户头像[255]")
    private String avatar;
    @ApiModelProperty(position = 12, value = "用户昵称[32]")
    private String nickname;
    @ApiModelProperty(position = 13, value = "用户性别[32]")
    private AdamTagVo sex;
    @ApiModelProperty(position = 14, value = "内容ID[64]")
    private String contentId;
    @ApiModelProperty(position = 15, value = "内容类型")
    private String type;

    private static final AdamDisposedUserVo obj = new AdamDisposedUserVo();

    public static AdamDisposedUserVo getNew() {
        try {
            return (AdamDisposedUserVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamDisposedUserVo();
        }
    }
}
