package com.liquidnet.service.kylin.dao.report;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 演出
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinPerformancesDto implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    /**
     * 演出id
     */
    private String performancesId;

    /**
     * 演出名
     */
    private String title;

    /**
     * 城市
     */
    private String cityName;

    /**
     * 总销售数量  -张   saleGeneral
     */
    private BigDecimal open;

    /**
     * 总销售金额  totalSalePrice
     */
    private BigDecimal totalSalePrice;

    /**
     * 总销售代理
     */
    private Long totalOutAgent;

    /**
     * 演出结束时间
     */
    private LocalDateTime timeEnd;

    /**
     * 演出结束时间
     */
    private LocalDateTime timeStart;

    /**
     * 顺序
     */
    private String comment;

    /**
     * 演出状态
     */
    private int status;
}
