drop table if exists sweet_qr_code;
create table sweet_qr_code
(
    mid        bigint unsigned auto_increment primary key,
    type       int          default 0 comment '活动type类型',
    url        varchar(128) default '' comment '二维码地址',
    show_num   int          default 0 comment '展示次数',
    read_num   int          default 0 comment '访问次数',
    created_at timestamp    default CURRENT_TIMESTAMP not null,
    KEY `sweet_qr_code_type` (`type`)
) engine = InnoDB comment 'type二维码表';


drop table if exists sweet_active_type;
create table sweet_active_type
(
    mid         bigint unsigned auto_increment primary key,
    active_name varchar(64) default '' comment '活动名称',
    type        int         default 0 comment 'type类型',
    alarm_num   int         default 0 comment '预警数量',
    max_count   int         default 8000 comment '最大访问次数',
    created_at  timestamp   default CURRENT_TIMESTAMP not null,
    KEY `sweet_active_type_active_name_index` (`active_name`)
) engine = InnoDB comment '活动type表';
