package com.liquidnet.client.admin.zhengzai.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.zhengzai.sweet.service.ISweetAdminActiveTypeService;
import com.liquidnet.client.admin.zhengzai.sweet.service.ISweetAdminQrCodeService;
import com.liquidnet.service.kylin.dto.param.CreateActiveQrCodeParam;
import com.liquidnet.service.kylin.dto.param.CreateActiveTypeParam;
import com.liquidnet.service.sweet.entity.SweetActiveType;
import com.liquidnet.service.sweet.entity.SweetQrCode;
import com.liquidnet.service.sweet.mapper.SweetActiveTypeMapper;
import com.liquidnet.service.sweet.mapper.SweetQrCodeMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
@Slf4j
public class SweetAdminQrCodeServiceImpl implements ISweetAdminQrCodeService {

    @Autowired
    SweetQrCodeMapper sweetQrCodeMapper;

    @Override
    public List<SweetQrCode> getList(String type) {
        return sweetQrCodeMapper.selectList(Wrappers.lambdaQuery(SweetQrCode.class).eq(SweetQrCode::getType, type));
    }

    @Override
    public Boolean addQrCode(CreateActiveQrCodeParam createActiveTypeParam) {
        try {
            SweetQrCode bean = SweetQrCode.getNew();
            int count = sweetQrCodeMapper.selectCount(Wrappers.lambdaQuery(SweetQrCode.class).eq(SweetQrCode::getType, createActiveTypeParam.getType()));
            for (int i = 0; i < createActiveTypeParam.getCount(); i++) {
                bean.setUrl(createActiveTypeParam.getUrl().concat("&") + (count + i + 1));
                bean.setReadNum(0);
                bean.setShowNum(0);
                bean.setType(createActiveTypeParam.getType());
                sweetQrCodeMapper.insert(bean);
            }
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public SweetQrCode details(String mid) {
        return sweetQrCodeMapper.selectOne(Wrappers.lambdaQuery(SweetQrCode.class).eq(SweetQrCode::getMid, mid));
    }

    @Override
    public Boolean changeInfo(CreateActiveQrCodeParam createActiveTypeParam) {
        SweetQrCode bean = SweetQrCode.getNew();
        bean.setReadNum(createActiveTypeParam.getReadNum());
        return sweetQrCodeMapper.update(bean, Wrappers.lambdaUpdate(SweetQrCode.class).eq(SweetQrCode::getMid, createActiveTypeParam.getMid())) > 0;
    }
}
