package com.liquidnet.service.adam.dto.param.admin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel(value = "AdamMemberOrderRefundParam", description = "会员订单退款入参")
@Data
public class AdamMemberOrderRefundParam implements Serializable {
    private static final long serialVersionUID = 3811495229630522458L;
    @NotBlank(message = "订单号不能为空")
    @ApiModelProperty(required = true, value = "订单号")
    private String orderNo;
    @NotNull(message = "退款金额不能为空")
    @DecimalMin(value = "0.01", message = "退款金额不能小于0.01")
    @ApiModelProperty(required = true, value = "退款金额")
    private BigDecimal refundAmt;
    @NotNull(message = "请选择是否能继续购买会员")
    @ApiModelProperty(required = true, value = "是否能继续购买会员[1-是｜2-否]")
    private Integer buyMark;
    @NotBlank(message = "请输入退款原因")
    @ApiModelProperty(required = true, value = "退款原因")
    private String reason;
}
