package com.liquidnet.service.adam.dto.param.admin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "AdamMemberRightsBuildParam", description = "编辑权益入参")
@Data
public class AdamMemberRightsBuildParam implements Serializable {
    private static final long serialVersionUID = -7331274160877946420L;
    @ApiModelProperty(required = true, value = "会员卡ID")
    private String memberId;
    @ApiModelProperty(required = false, value = "权益ID[64]")
    private String mrightsId;
    @ApiModelProperty(required = true, value = "权益状态[]")
    private Integer state;

    @ApiModelProperty(required = true, value = "权益标题[50]")
    private String title;
    @ApiModelProperty(required = true, value = "权益副标题[200]")
    private String subTitle;
    @ApiModelProperty(required = false, value = "标注[50]")
    private String label;
    @ApiModelProperty(required = true, value = "权益封面图片[255]")
    private String cover;
    @ApiModelProperty(required = false, value = "详情内容")
    private String detail;
    @ApiModelProperty(required = true, value = "展示顺序[2]")
    private Integer seqNo;
}
