package com.liquidnet.client.admin.zhengzai.goblin.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinInsertZhengzaiParam;
import com.liquidnet.service.goblin.dto.vo.GoblinMarketSpuListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfMarketingVo;
import com.liquidnet.service.goblin.dto.vo.GoblinSelfZhengzaiSkuVo;
import com.liquidnet.service.goblin.dto.vo.GoblinZhengzaiStoreListVo;
import com.liquidnet.service.goblin.entity.GoblinSelfMarketing;

import java.util.List;

/**
 * 正在下单相关
 */
public interface IGoblinZhengzaiMarketService {

    /**
     * 正在下单列表
     *
     * @param page         页数
     * @param purchaseName 活动名称
     * @param status       状态
     * @param st           开始时间
     * @param et           结束时间
     * @param ct           创建时间
     * @return
     */
    ResponseDto<List<GoblinSelfMarketing>> zhengzaiList(int page, String purchaseName, int status, String st, String et, String ct);

    /**
     * 正在状态操作
     *
     * @param marketId 活动秒杀id
     * @param status   状态
     * @return
     */
    ResponseDto<Boolean> zhengzaiStatus(String marketId, int status);

    /**
     * 添加 正在下单活动
     *
     * @param purchaseName 活动名称
     * @param st           开始时间
     * @param et           结束时间
     * @return
     */
    ResponseDto<String> zhengzaiInsert(String purchaseName, String performancesId, String st, String et);

    /**
     * @param marketId     活动id
     * @param purchaseName 秒杀活动名称
     * @param st           开始时间
     * @param et           结束时间
     * @return
     */
    ResponseDto<Boolean> zhengzaiUpdate(String marketId, String purchaseName, String st, String et);

    /**
     * 获取 限时秒杀 详情
     *
     * @param marketId 活动秒杀id
     * @return
     */
    ResponseDto<GoblinSelfMarketingVo> zhengzaiDetails(String marketId);

    /**
     * 获取活动内spu列表
     *
     * @param marketId 活动秒杀id
     * @param storeId  页数
     * @return
     */
    ResponseDto<List<GoblinMarketSpuListVo>> zhengzaiSpuList(String marketId, String storeId, int page);

    /**
     * 获取活动内sku列表
     *
     * @param marketId 活动秒杀id
     * @param storeId  页数
     * @return
     */
    ResponseDto<List<GoblinSelfZhengzaiSkuVo>> zhengzaiSkuList(String marketId, String storeId, String spuId);

    /**
     * 删除活动内sku
     *
     * @param marketId 活动秒杀id
     * @param spuId    spuId
     * @return
     */
    ResponseDto<Boolean> zhengzaiSkuDel(String marketId, String storeId, String spuId);


    /**
     * 添加正在下单 可参与活动店铺
     *
     * @return
     */
    ResponseDto<Boolean> zhengzaiStore(List<GoblinInsertZhengzaiParam> params);

    /**
     * 编辑正在下单 可参与活动店铺
     *
     * @param marketId
     * @param storeId
     * @return
     */
    ResponseDto<Boolean> zhengzaiStore(String marketId, String storeId, String showTime, Integer delTag);

    /**
     * 查看详情(参加活动的商品列表)
     *
     * @param marketId
     * @return
     */
    ResponseDto<List<GoblinZhengzaiStoreListVo>> zhengzaiStoreList(String marketId);


}
