package com.liquidnet.client.admin.zhengzai.smile.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author TT
 */
@Data
public class UserCheckParam {

    @ApiModelProperty(value = "审核id", example = "")
    private Long id;

    @ApiModelProperty(value = "姓名", example = "")
    private String name;

    @ApiModelProperty(value = "手机号", example = "")
    private String phone;

    @ApiModelProperty(value = "审核状态", example = "")
    private Integer state;

    @ApiModelProperty(value = "页数", example = "0")
    @NotNull(message = "页数不能为空")
    private Integer pageSize;

    @ApiModelProperty(value = "数量", example = "20")
    @NotNull(message = "数量不能为空")
    private Integer pageNum;

    @ApiModelProperty(value = "排序字段", hidden = true)
    private String orderItem;

    @ApiModelProperty(value = "排序方式", hidden = true)
    private String orderSc;

}
