package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 场地关系
 * </p>
 *
 * @author liquidnet
 * @since 2021-04-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinFieldRelations implements Serializable  ,Cloneable{

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * field_relations_id
     */
    private String fieldRelationsId;

    /**
     * 场地关联id
     */
    private String fieldId;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

    private static final KylinFieldRelations obj = new KylinFieldRelations();
    public static KylinFieldRelations getNew() {
        try {
            return (KylinFieldRelations) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinFieldRelations();
        }
    }
}
