package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.liquidnet.client.admin.zhengzai.kylin.dto.ActiveTicketExportVo;
import com.liquidnet.service.kylin.dao.KylinTicketActive;
import com.liquidnet.service.kylin.mapper.KylinTicketActiveMapper;
import com.liquidnet.service.kylin.service.IKylinTicketActiveService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 跟活动绑定的券 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-07-12
 */
@Service
public class KylinTicketActiveServiceImpl extends ServiceImpl<KylinTicketActiveMapper, KylinTicketActive> implements IKylinTicketActiveService {
    @Autowired
    private KylinTicketActiveMapper kylinTicketActiveMapper;
    @Override
    public List<KylinTicketActive> pageKylinAcitve(int pageSize, int pageNumber, String activeId) {
            PageHelper.startPage(pageNumber, pageSize);
            LambdaQueryWrapper<KylinTicketActive> queryWrapper = Wrappers.lambdaQuery(KylinTicketActive.class);
            queryWrapper.eq(KylinTicketActive::getActivityId,activeId);
            List<KylinTicketActive> list=kylinTicketActiveMapper.selectList(queryWrapper);
            return list;
    }

    public List<ActiveTicketExportVo> exportTicket(String activeId) {
        LambdaQueryWrapper<KylinTicketActive> queryWrapper = Wrappers.lambdaQuery(KylinTicketActive.class);
        queryWrapper.eq(KylinTicketActive::getActivityId,activeId);
        List<KylinTicketActive> list=kylinTicketActiveMapper.selectList(queryWrapper);
        List<ActiveTicketExportVo> voList = new ArrayList();
        for (KylinTicketActive item : list) {
            ActiveTicketExportVo activeTicketExportVo=ActiveTicketExportVo.getNew();
            activeTicketExportVo.setCode(item.getCode());
            activeTicketExportVo.setRedeemUid(item.getRedeemUid()==null?"":item.getRedeemUid());
            if(item.getState()==1){
                activeTicketExportVo.setState("未兑换");
            }else if(item.getState()==2){
                activeTicketExportVo.setState("已兑换");
            }else{
                activeTicketExportVo.setState("已失效");
            }
            voList.add(activeTicketExportVo);
        }
        return voList;
    }
}
