package com.liquidnet.service.bank.currencycloud.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.bank.config.swagger.BankSwaggerApiVersionConstant;
import com.liquidnet.service.bank.currencycloud.dto.BankCcAccountCreateDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcAccountCreateParam;
import com.liquidnet.service.bank.currencycloud.service.IBankCcAccountService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-12
 */
@Api(tags = "account")
@Slf4j
@RestController
@RequestMapping("/bank-cc-account")
public class BankCcAccountController {

    @Autowired
    private IBankCcAccountService bankCcAccountService;

    @ApiOperation(value = "create account")
    @SwaggerApiVersion(group = BankSwaggerApiVersionConstant.API_CC)
    @PostMapping("/create")
    public ResponseDto<BankCcAccountCreateDto> createAccount(HttpServletRequest request,
                                                             @RequestBody BankCcAccountCreateParam param) {
        log.info("[{}],create account,BankCcAccountParam=[{}]", param.getBankCcAccountParam().getUniqueRequestId(), JSON.toJSONString(param, SerializerFeature.WriteMapNullValue));
        ResponseDto<BankCcAccountCreateDto> responseDto;
        try {
            responseDto = bankCcAccountService.createAccount(param);
        } catch (Exception e) {
            log.error("create account error", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }
        return responseDto;
    }

}
