package com.liquidnet.service.platform.controller.kylin;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.KylinTimePerformanceVo;
import com.liquidnet.service.kylin.dto.vo.PerformanceOrderStatisticalVo;
import com.liquidnet.service.kylin.service.partner.IKylinPerformancesPartnerService;
import com.liquidnet.service.platform.utils.PerformanceVoTask;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.List;

import static com.liquidnet.commons.lang.util.DateUtil.DTF_YMD_HMS;

/**
 * <p>
 * 演出 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-11
 */
@Api(tags = "前端-演出")
@RestController
@RequestMapping("performance")
@Slf4j
public class KylinPerformancesController {

    @Autowired
    private PerformanceVoTask performanceVoTask;
    @Autowired
    private IKylinPerformancesPartnerService performancesPartnerService;
    @Autowired
    private MongoTemplate mongoTemplate;

    @PostMapping("/checkPerformanceTime")
    @ApiOperation("演出脚本")
    public ResponseDto<String> checkPerformanceTime(@RequestParam(value = "performancesId", required = false) String performancesId) {
        try {
            performanceVoTask.performanceVoStatus(performancesId);
            return ResponseDto.success("成功");
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.success("失败");
        }
    }

    @GetMapping(value = "line")
    @ApiOperation(value = "演出状态管理", position = 9)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<Boolean> performanceLine(@RequestParam("performancesId") @NotNull(message = "演出ID不能为空") String performancesId) {
        try {
            List<KylinTimePerformanceVo> voList = mongoTemplate.findAll(KylinTimePerformanceVo.class, KylinTimePerformanceVo.class.getSimpleName());
            for (KylinTimePerformanceVo item : voList) {
                if (LocalDateTime.now().isAfter(LocalDateTime.parse(item.getTime(), DTF_YMD_HMS).plusSeconds(2))) {
                    if (item.getTaskType() == 1) {
                        performancesPartnerService.onLinePerformance(item.getPerformanceId());
                        log.info("[FINISH ON LINE TASK] performanceId = " + item.getPerformanceId() + " time = " + item.getTime());
                    } else if (item.getTaskType() == 2) {
                        performancesPartnerService.outLinePerformance(item.getPerformanceId());
                        log.info("[FINISH OUT LINE TASK] performanceId = " + item.getPerformanceId() + " time = " + item.getTime());
                    }
                }
            }
            return ResponseDto.success(true);
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.success(false);
        }
    }
}
