package com.liquidnet.service.goblin.controller.manage;

import com.github.pagehelper.PageInfo;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinMailVo;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreOrderListVo;
import com.liquidnet.service.goblin.param.RefundCallbackParam;
import com.liquidnet.service.goblin.service.IGoblinOrderService;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreOrderService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.util.List;

@ApiSupport(order = 149101)
@Api(tags = "店铺-订单")
@Slf4j
@Validated
@RestController
@RequestMapping("store/order")
public class GoblinStoreOrderController {
    @Autowired
    IGoblinStoreOrderService goblinStoreOrderService;
//    @Autowired
//    IGoblinOrderService goblinOrderService;

    @ApiOperation(value = "订单列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "page", value = "页数"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "orderCode", value = "订单编号"),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "type", value = "订单类型[0-全部|1-普通订单]"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "cst", value = "下单起始时间"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "cet", value = "下单终止时间"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "expressContacts", value = "收货人姓名"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "phone", value = "手机号"),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "status", value = "订单状态[0-代付款|2-待发货|3-已发货|4-已完成]"),
    })
    @GetMapping(value = "list")
    public ResponseDto<PageInfo<GoblinStoreOrderListVo>> orderList(@RequestParam(value = "page", required = true) @Valid Integer page,
                                                                   @RequestParam(value = "orderCode", required = false) String orderCode,
                                                                   @RequestParam(value = "type", required = false) Integer type,
                                                                   @RequestParam(value = "cst", required = false) String cst,
                                                                   @RequestParam(value = "cet", required = false) String cet,
                                                                   @RequestParam(value = "expressContacts", required = false) String expressContacts,
                                                                   @RequestParam(value = "phone", required = false) String phone,
                                                                   @RequestParam(value = "status", required = false) Integer status) {

        return goblinStoreOrderService.orderList(page, orderCode, type, cst, cet, expressContacts, phone, status);
    }

    @ApiOperation(value = "订单详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id"),
    })
    @GetMapping(value = "details")
    public ResponseDto<GoblinStoreOrderListVo> orderDetails(@RequestParam(value = "orderId", required = true) @Valid String orderId) {
        return goblinStoreOrderService.orderDetails(orderId);
    }

    @ApiOperation(value = "取消订单")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id"),
    })
    @GetMapping(value = "cancel")
    public ResponseDto<Boolean> orderCancel(@RequestParam(value = "orderId", required = true) @Valid String orderId) {
        return goblinStoreOrderService.orderCancel(orderId);
    }

    @ApiOperation(value = "修改快递价格")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "BigDecimal", name = "price", value = "快递金额"),
    })
    @GetMapping(value = "change/expressPrice")
    public ResponseDto<Boolean> changeExpressPrice(@RequestParam(value = "orderId", required = true) @Valid String orderId,
                                                   @RequestParam(value = "price", required = true) @Valid BigDecimal price) {
        return goblinStoreOrderService.changeExpressPrice(orderId, price);
    }

    @ApiOperation(value = "修改sku价格")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderSkuId", value = "orderSkuId"),
            @ApiImplicitParam(type = "form", required = true, dataType = "BigDecimal", name = "price", value = "修改金额"),
    })
    @GetMapping(value = "change/skuPrice")
    public ResponseDto<Boolean> changeSkuPrice(@RequestParam(value = "orderId", required = true) @Valid String orderId,
                                               @RequestParam(value = "orderSkuId", required = true) @Valid String orderSkuId,
                                               @RequestParam(value = "price", required = true) @Valid BigDecimal price) {
        return goblinStoreOrderService.changeSkuPrice(orderId, orderSkuId, price);
    }

    @ApiOperation(value = "修改收货地址")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "expressAddressDetail", value = "详细快递地址"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "expressContacts", value = "联系人"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "expressPhone", value = "联系人电话"),
    })
    @GetMapping(value = "change/address")
    public ResponseDto<Boolean> changeAddress(@RequestParam(value = "orderId", required = true) @Valid String orderId,
                                              @RequestParam(value = "expressContacts", required = true) @Valid String expressContacts,
                                              @RequestParam(value = "expressPhone", required = true) @Valid String expressPhone,
                                              @RequestParam(value = "expressAddressDetail", required = true) @Valid String expressAddressDetail) {
        return goblinStoreOrderService.changeAddress(orderId, expressContacts, expressPhone, expressAddressDetail);
    }

    @ApiOperation(value = "退款(sku/整单)")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "orderSkuId", value = "orderSkuId[整单退不传]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "BigDecimal", name = "price", value = "退款金额"),
    })
    @GetMapping(value = "refund/sku")
    public ResponseDto<Boolean> refundOrderSku(@RequestParam(value = "orderId", required = true) @Valid String orderId,
                                               @RequestParam(value = "orderSkuId", required = false) String orderSkuId,
                                               @RequestParam(value = "price", required = true) @Valid BigDecimal price) {
        return goblinStoreOrderService.refundOrderSku(orderId, orderSkuId, price);
    }

    @ApiOperation(value = "发货")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "orderSkuIds", value = "逗号隔开orderSkuId"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "mailNo", value = "快递单号"),
    })
    @GetMapping(value = "express")
    public ResponseDto<Boolean> express(@RequestParam(value = "orderId", required = true) @Valid String orderId,
                                        @RequestParam(value = "orderSkuIds", required = false) @Valid String orderSkuIds,
                                        @RequestParam(value = "mailNo", required = true) @Valid String mailNo) {
        return goblinStoreOrderService.express(orderId, orderSkuIds, mailNo);
    }

    @ApiOperation(value = "修改快递单号")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "mailId", value = "快递id"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "mailNo", value = "快递单号"),
    })
    @GetMapping(value = "express/change")
    public ResponseDto<Boolean> changeExpressMailNo(@RequestParam(value = "orderId", required = true) @Valid String orderId,
                                                    @RequestParam(value = "mailId", required = false) @Valid String mailId,
                                                    @RequestParam(value = "mailNo", required = true) @Valid String mailNo) {
        return goblinStoreOrderService.changeExpressMailNo(orderId, mailId, mailNo);
    }

}
