package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 发行+购买结果查询
 * @class: GalaxyNftPublishResultQueryRespDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/28 11:22
 */
@ApiModel(value = "GalaxyNftPublishResultQueryRespDto", description = "NFT发行结果查询")
@Data
public class GalaxyNftPublishAndBuyResultQueryRespDto implements Serializable,Cloneable {
    /**
     * nftId格式，发行人公钥hash_系列_系列索引id,申请多少个，最后一段计算出来即可，
     * 比如申请10个，nftIdBegin位xx_xx_1,那么就可以推导出x_xx_1到x_xx_10
     */
    @ApiModelProperty(position = 3, required = true, value = "nftId格式")
    private String nftIdBegin;

    @Override
    public String toString() {
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftPublishAndBuyResultQueryRespDto obj = new GalaxyNftPublishAndBuyResultQueryRespDto();

    public static GalaxyNftPublishAndBuyResultQueryRespDto getNew() {
        try {
            return (GalaxyNftPublishAndBuyResultQueryRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftPublishAndBuyResultQueryRespDto();
        }
    }
}
