package com.liquidnet.service.adam.dto.vo.admin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * upush 系统消息
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-15
 */
@ApiModel
@Data
public class AdminUpushVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 8635450456535735379L;

    @ApiModelProperty(value = "upush_id")
    private String upushId;

    @ApiModelProperty(value = "推送设备 1all 2ios 3android")
    private Integer pushRange;

    @ApiModelProperty(value = "推送标题")
    private String pushTitle;

    @ApiModelProperty(value = "推送内容")
    private String pushContent;

    @ApiModelProperty(value = "封面图")
    private String img;

    @ApiModelProperty(value = "跳转类型 0打开APP,16演出首页,17商城首页,5场地详情,6票务详情,7商品详情,14商品集合,20音乐人详情,24音乐人集合,21歌曲详情,22专辑详情,26摩登会员,12活动跳转可分享,100活动跳转,32系统消息列表")
    private Integer jumpType;

    @ApiModelProperty(value = "跳转值 id或者url或者空 根据type区分")
    private String jumpValue;

    @ApiModelProperty(value = "跳转对应的值名称")
    private String jumpContent;

    @ApiModelProperty(value = "推送时间 定时推送")
    private String pushTime;

    @ApiModelProperty(value = "是否发送推送消息，2不发送 1发送推送消息")
    private Integer isPush;

    @ApiModelProperty(value = "发送类型，2立即发送 1定时发送")
    private Integer sendType;

    @ApiModelProperty(value = "消息类型，2系统消息 1会员消息 会员不做了 默认2")
    private Integer messageType;

    @ApiModelProperty(value = "用户类型，2全部用户 1指定手机号 指定手机不做了默认2")
    private Integer specifyType;

    @ApiModelProperty(value = "消息展示类型，2普通文本，1图文排版")
    private Integer messageShowType;

    @ApiModelProperty(value = "推送者ID")
    private String pushedBy;

    @ApiModelProperty(value = "推送者姓名")
    private String pushedName;

    @ApiModelProperty(value = "任务类消息(type为broadcast、groupcast、filecast、customizedcast且file_id不为空)返回")
    private String taskId;

    @ApiModelProperty(value = "单播类消息(type为unicast、listcast、customizedcast且不带file_id)返回")
    private String msgId;

    @ApiModelProperty(value = "错误码")
    private String errorCode;

    @ApiModelProperty(value = "错误信息")
    private String errorMsg;

    private String createdAt;

    private String updatedAt;

    private static final AdminUpushVo obj = new AdminUpushVo();

    public static AdminUpushVo getNew() {
        try {
            return (AdminUpushVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdminUpushVo();
        }
    }
}
