package com.liquidnet.client.admin.web.controller.zhengzai.kylin;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.common.utils.poi.ExcelUtil;
import com.liquidnet.client.admin.zhengzai.kylin.dto.OrderExpressExportExcelListDao;
import com.liquidnet.client.admin.zhengzai.kylin.dto.performancesExpressImportVo;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.PerformancesExpressServiceImpl;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.OrderExpressExportListDao;
import com.liquidnet.service.kylin.dao.PerformanceExpressPerformanceListAdminDao;
import com.liquidnet.service.kylin.dao.PerformanceExpressPerformanceOrderListAdminDao;
import com.liquidnet.service.kylin.dao.PerformancesTicketListDao;
import com.liquidnet.service.kylin.dto.param.PerformanceExpressSearchAdminParam;
import com.liquidnet.service.kylin.dto.vo.express.KylinOrderExpressPrintVo;
import com.liquidnet.service.kylin.entity.KylinExpressModule;
import com.liquidnet.service.kylin.mapper.KylinExpressModuleMapper;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 演出快递
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-06-21
 */

@Controller
@RequestMapping("/kylin/performancesExpress")
public class PerformancesExpressController extends BaseController {

    private String prefix = "zhengzai/kylin/performancesExpress";

    @Autowired
    private PerformancesExpressServiceImpl performancesExpressServiceImpl;

    @Autowired
    private KylinExpressModuleMapper kylinExpressModuleMapper;

    /**
     * 查询演出列表
     */
    @RequiresPermissions("kylin:performancesExpress:view")
    @GetMapping()
    public String performancesListView() {
        return prefix + "/performancesList";
    }


    @Log(title = "快递管理-演出列表", businessType = BusinessType.LIST)
    @RequiresPermissions("kylin:performancesExpress:performancesList")
    @PostMapping("/performancesList")
    @ResponseBody
    public TableDataInfo performancesList(PerformanceExpressSearchAdminParam performanceExpressSearchAdminParam) {
        List<PerformanceExpressPerformanceListAdminDao> result = performancesExpressServiceImpl.getPerformancesList(performanceExpressSearchAdminParam);
        return getDataTable(result);
    }

    /**
     * 查询演出订单列表
     */
    @RequiresPermissions("kylin:performancesExpress:performanceOrderList")
    @GetMapping("performanceOrderList/{id}")
    public String performanceOrderListView(@PathVariable("id") String id, ModelMap mmap) {
        List<PerformancesTicketListDao> performancesTicketList = performancesExpressServiceImpl.getPerformancesTicketList(id);
        List<KylinExpressModule> expressModuleList = kylinExpressModuleMapper.selectList(Wrappers.lambdaQuery(KylinExpressModule.class));
        mmap.put("performancesId", id);
        mmap.put("performancesTicketList", performancesTicketList);
        mmap.put("expressModuleList", expressModuleList);
        return prefix + "/performanceOrderList";
    }

    @Log(title = "快递管理-演出订单列表", businessType = BusinessType.LIST)
    @RequiresPermissions("kylin:performancesExpress:performanceOrderList")
    @PostMapping("/performanceOrderList")
    @ResponseBody
    public TableDataInfo performanceOrderList(PerformanceExpressSearchAdminParam performanceExpressSearchAdminParam) {
        List<PerformanceExpressPerformanceOrderListAdminDao> orderList = performancesExpressServiceImpl.getPerformancesOrderList(performanceExpressSearchAdminParam);
        return getDataTable(orderList);
    }

    /**
     * 下单
     */
    @Log(title = "快递管理-演出订单列表", businessType = BusinessType.LIST)
    @RequiresPermissions("kylin:performancesExpress:placeOrder")
    @PostMapping("/placeOrder")
    @ResponseBody
    public AjaxResult placeOrder(PerformanceExpressSearchAdminParam performanceExpressSearchAdminParam) {
        ResponseDto res = performancesExpressServiceImpl.placeOrder(performanceExpressSearchAdminParam);
        try {
            if (res.isSuccess()) {
                return success();
            } else {
                return error(res.getMessage());
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    /**
     * 取消
     */
    @Log(title = "快递管理-演出订单列表", businessType = BusinessType.CANCEL)
    @RequiresPermissions("kylin:performancesExpress:cancelOrder")
    @PostMapping("/cancelOrder")
    @ResponseBody
    public AjaxResult cancelOrder(PerformanceExpressSearchAdminParam performanceExpressSearchAdminParam) {
        ResponseDto res = performancesExpressServiceImpl.cancelOrder(performanceExpressSearchAdminParam);
        try {
            if (res.isSuccess()) {
                return success();
            } else {
                return error(res.getMessage());
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    /**
     * 下单结果主动查询
     */
    @RequiresPermissions("kylin:performancesExpress:getResult")
    @PostMapping("/getResult")
    @ResponseBody
    public AjaxResult getResult(PerformanceExpressSearchAdminParam performanceExpressSearchAdminParam) {
        ResponseDto res = performancesExpressServiceImpl.getResult(performanceExpressSearchAdminParam);
        try {
            if (res.isSuccess()) {
                return success();
            } else {
                return error(res.getMessage());
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    /**
     * 订单运费估算
     */
    @RequiresPermissions("kylin:performancesExpress:getFreight")
    @PostMapping("/getFreight")
    @ResponseBody
    public AjaxResult getFreight(PerformanceExpressSearchAdminParam performanceExpressSearchAdminParam) {
        ResponseDto res = performancesExpressServiceImpl.getFreight(performanceExpressSearchAdminParam);
        try {
            if (res.isSuccess()) {
                return success();
            } else {
                return error(res.getMessage());
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    /**
     * 路由信息主动查询
     */
    @RequiresPermissions("kylin:performancesExpress:listOrderRoute")
    @PostMapping("/listOrderRoute")
    @ResponseBody
    public AjaxResult listOrderRoute(PerformanceExpressSearchAdminParam performanceExpressSearchAdminParam) {
        ResponseDto res = performancesExpressServiceImpl.listOrderRoute(performanceExpressSearchAdminParam);
        try {
            if (res.isSuccess()) {
                return success();
            } else {
                return error(res.getMessage());
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    /**
     * 实际运费主动查询 暂时可先不用
     */
    @RequiresPermissions("kylin:performancesExpress:getListFreight")
    @PostMapping("/getListFreight")
    @ResponseBody
    public AjaxResult getListFreight(PerformanceExpressSearchAdminParam performanceExpressSearchAdminParam) {
        ResponseDto res = performancesExpressServiceImpl.getListFreight(performanceExpressSearchAdminParam);
        try {
            if (res.isSuccess()) {
                return success();
            } else {
                return error(res.getMessage());
            }
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    /**
     * 预计派件时间
     */

    /**
     * 通缉拦截
     * 该接口只能在揽收后，派送成功前生效
     * 同一订单在成功通缉拦截一次后，不可再次进行通缉拦截
     * 1-转寄；2-退回；3-优派；4-再派；5-改自取（改派-其他自取点取件）；6-改派送（上门派送）；7-更改派送时间；8-修改收件人信息；9-更改付款方式；10-修改代收货款；12-作废；
     */

    /**
     * 订单确认 快递员上门揽收前，如需修改部分下单内容（如收件人信息等
     */

    /**
     * 批量下单
     */
    @Log(title = "快递管理-演出列表", businessType = BusinessType.PLACE_ORDER)
    @RequiresPermissions("kylin:performancesExpress:batchPlaceOrder")
    @PostMapping("/batchPlaceOrder")
    @ResponseBody
    public AjaxResult batchPlaceOrder(@RequestParam("ids") String performanceId) {
        try {
            performancesExpressServiceImpl.batchPlaceOrder(performanceId);
            return success();
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    /**
     * 批量取消
     */
    @Log(title = "快递管理-演出列表", businessType = BusinessType.CANCEL)
    @RequiresPermissions("kylin:performancesExpress:batchCancelOrder")
    @PostMapping("/batchCancelOrder")
    @ResponseBody
    public AjaxResult batchCancelOrder(@RequestParam("ids") String performanceId) {
        try {
            performancesExpressServiceImpl.batchCancelOrder(performanceId);
            return success();
        } catch (Exception e) {
            return error(e.getMessage());
        }
    }

    /**
     * 批量下载图片
     */
    @Log(title = "快递管理-演出列表", businessType = BusinessType.BATCH_DOWNLOAD_IMAGE)
    @RequiresPermissions("kylin:performancesExpress:batchGenerateImage")
    @PostMapping("/batchGenerateImage")
    @ResponseBody
    public ResponseDto batchGenerateImage(@RequestParam("ids") String performanceId) {
        String res = performancesExpressServiceImpl.batchGenerateImage(performanceId);
        try {
            if (res.isEmpty()) {
                return ResponseDto.failure("处理失败");
            } else {
                return ResponseDto.success(res);
            }
        } catch (Exception e) {
            return ResponseDto.failure(e.getMessage());
        }
    }

    /**
     * 下载图片
     */
    @Log(title = "快递管理-演出列表", businessType = BusinessType.DOWNLOAD_IMAGE)
    @RequiresPermissions("kylin:performancesExpress:generateImage")
    @PostMapping("/generateImage")
    @ResponseBody
    public ResponseDto generateImage(PerformanceExpressSearchAdminParam performanceExpressSearchAdminParam) {
        String res = performancesExpressServiceImpl.generateImage(performanceExpressSearchAdminParam);
        try {
            if (res.isEmpty()) {
                return ResponseDto.failure("处理失败");
            } else {
                return ResponseDto.success(res);
            }
        } catch (Exception e) {
            return ResponseDto.failure(e.getMessage());
        }
    }

    /**
     * 批量打印获取数据
     */
    @Log(title = "快递管理-演出列表", businessType = BusinessType.BATCH_PRINT)
    @RequiresPermissions("kylin:performancesExpress:batchPrintExpress")
    @PostMapping("/batchPrintExpress")
    @ResponseBody
    public ResponseDto<KylinOrderExpressPrintVo> batchPrintExpress(@RequestParam("ids") String performanceId, @RequestParam("ticketId") String ticketId, @RequestParam("printNum") Integer printNum) {
        KylinOrderExpressPrintVo res = performancesExpressServiceImpl.batchPrintExpress(performanceId, ticketId, printNum);
        try {
            return ResponseDto.success(res);
        } catch (Exception e) {
            return ResponseDto.failure(e.getMessage());
        }
    }

    /**
     * 获取演出票种列表
     */
    @Log(title = "快递管理-演出列表", businessType = BusinessType.LIST)
    @PostMapping("/getPerformancesTicketList")
    @ResponseBody
    public TableDataInfo getPerformancesTicketList(@RequestParam("ids") String performanceId) {
        List<PerformancesTicketListDao> result = performancesExpressServiceImpl.getPerformancesTicketList(performanceId);
        return getDataTable(result);
    }

    /**
     * 打印单条获取数据
     */
    @Log(title = "快递管理-演出列表", businessType = BusinessType.PRINT)
    @RequiresPermissions("kylin:performancesExpress:printExpress")
    @PostMapping("/printExpress")
    @ResponseBody
    public ResponseDto<KylinOrderExpressPrintVo> printExpress(PerformanceExpressSearchAdminParam performanceExpressSearchAdminParam) {
        KylinOrderExpressPrintVo res = performancesExpressServiceImpl.printExpress(performanceExpressSearchAdminParam);
        try {
            return ResponseDto.success(res);
        } catch (Exception e) {
            return ResponseDto.failure(e.getMessage());
        }
    }

    /**
     * 导出快递票订单
     */
    @Log(title = "快递管理-演出列表", businessType = BusinessType.PRINT)
    @RequiresPermissions("kylin:performancesExpress:exportExcel")
    @PostMapping("/export")
    @ResponseBody
    public AjaxResult export(@RequestParam("ids") String performanceId) {
        List<OrderExpressExportListDao> list = performancesExpressServiceImpl.selectExpressList(performanceId);
        ExcelUtil<OrderExpressExportExcelListDao> excelUtil = new ExcelUtil<>(OrderExpressExportExcelListDao.class);
        List<OrderExpressExportExcelListDao> excelList = new ArrayList<>();
        list.forEach(r -> {
            excelList.add(OrderExpressExportExcelListDao.getNew().copy(r));
        });
        return excelUtil.exportExcel(excelList, "快递信息");
    }

    /**
     * 下载导入模版
     * @return
     */
    @GetMapping("/importTemplate")
    @ResponseBody
    public AjaxResult importTemplate()
    {
        ExcelUtil<performancesExpressImportVo> util = new ExcelUtil<performancesExpressImportVo>(performancesExpressImportVo.class);
        return util.importTemplateExcel("快递信息");
    }

    /**
     * 导入外部快递信息
     */
    @Log(title = "快递管理-演出列表", businessType = BusinessType.PRINT)
    @RequiresPermissions("kylin:performancesExpress:import")
    @PostMapping("/importData")
    @ResponseBody
    public AjaxResult importData(MultipartFile file) {
        try {
            ExcelUtil<performancesExpressImportVo> util = new ExcelUtil<performancesExpressImportVo>(performancesExpressImportVo.class);
            List<performancesExpressImportVo> expressList = util.importExcel(file.getInputStream());
            String message = performancesExpressServiceImpl.importExpress(expressList);
            return AjaxResult.success(message);
        } catch (Exception e) {
            logger.error("importDataException [e:{}]", e);
            return AjaxResult.error(e.getMessage());
        }
    }

}
