package com.liquidnet.service.consumer.sweet.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.entity.SweetWechatUser;
import com.liquidnet.service.sweet.vo.SweetWechatUsersVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class RedisDataUtils {

    @Autowired
    private RedisUtil redisUtil;

    public SweetWechatUsersVo getSweetWechatUsersOfUnionId(String unionId, Integer type) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_UNIONID.concat(unionId)
                .concat(SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_TYPE).concat(String.valueOf(type));
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            return null;
        } else {
            SweetWechatUsersVo sweetWechatUsersVo = (SweetWechatUsersVo) obj;
            return sweetWechatUsersVo;
        }
    }

}
