package com.liquidnet.service.kylin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.kylin.entity.KylinCamera;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * <p>
 * 人流量排队检测摄像头表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-01-11
 */

@Data
@ApiModel
public class KylinApiCameraDevicesVo implements Serializable {

    @ApiModelProperty(value = "camera_id")
    private String cameraId;

    @ApiModelProperty(value = "场地ID")
    private String fieldId;

    @ApiModelProperty(value = "地点类型 1卫生间 2。。。")
    private Integer siteType;

    @ApiModelProperty(value = "设备状态 取值：on(在线),off(离线),failed(锁定),new(未注册)")
    private String status;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;

    @ApiModelProperty(value = "修改时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    @ApiModelProperty(value = "检测到的人数")
    private Integer personNum;

    private static final KylinApiCameraDevicesVo obj = new KylinApiCameraDevicesVo();

    public static KylinApiCameraDevicesVo getNew() {
        try {
            return (KylinApiCameraDevicesVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinApiCameraDevicesVo();
        }
    }

    public KylinApiCameraDevicesVo copy(KylinCamera source) {
        KylinApiCameraDevicesVo kylinApiCameraDevicesVo = KylinApiCameraDevicesVo.getNew();
        if (null == source) return null;
        kylinApiCameraDevicesVo.setCameraId(source.getCameraId());
        kylinApiCameraDevicesVo.setFieldId(source.getFieldId());
        kylinApiCameraDevicesVo.setSiteType(source.getSiteType());
        kylinApiCameraDevicesVo.setStatus(source.getStatus());
        kylinApiCameraDevicesVo.setCreatedAt(source.getCreatedAt());
        kylinApiCameraDevicesVo.setUpdatedAt(source.getUpdatedAt());
        return kylinApiCameraDevicesVo;
    }

}
