package com.liquidnet.service.account.funding.dto;

import com.liquidnet.service.account.common.FinConstants;
import com.liquidnet.service.account.funding.dto.base.FundingCallParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * FundingTransactionParam.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/27
 */
@ApiModel(value = "FundingTransactionParam", description = "Parameters of funding account transaction")
public class FundingTransactionParam extends FundingCallParam {
    private static final long serialVersionUID = 1938744800966310772L;
    @ApiModelProperty(position = 11, required = true, value = "Funding account number [32]", example = "18400000001000")
    private String accNo;
    @ApiModelProperty(position = 12, required = true, value = "Transaction amount [20,6]", example = "1.00")
    private BigDecimal amount;
    @ApiModelProperty(position = 13, required = true, value = "Type of credit and debit")
    private FinConstants.CDType category;
    @ApiModelProperty(position = 14, required = true, value = "Wallet user ID [32]")
    private String finId;
    @ApiModelProperty(position = 15, required = true, value = "Wallet number [32]")
    private String walletNo;
    @ApiModelProperty(position = 16, required = true, value = "Wallet transaction number [32]")
    private String transNo;
    @ApiModelProperty(position = 17, required = true, value = "Transaction ID [32]")
    private String tracingNo;
    @ApiModelProperty(position = 18, required = true, value = "Transaction time [32]")
    private LocalDateTime tracingTime;

    public String getAccNo() {
        return accNo;
    }

    public void setAccNo(String accNo) {
        this.accNo = accNo;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public FinConstants.CDType getCategory() {
        return category;
    }

    public void setCategory(FinConstants.CDType category) {
        this.category = category;
    }

    public String getFinId() {
        return finId;
    }

    public void setFinId(String finId) {
        this.finId = finId;
    }

    public String getWalletNo() {
        return walletNo;
    }

    public void setWalletNo(String walletNo) {
        this.walletNo = walletNo;
    }

    public String getTransNo() {
        return transNo;
    }

    public void setTransNo(String transNo) {
        this.transNo = transNo;
    }

    public String getTracingNo() {
        return tracingNo;
    }

    public void setTracingNo(String tracingNo) {
        this.tracingNo = tracingNo;
    }

    public LocalDateTime getTracingTime() {
        return tracingTime;
    }

    public void setTracingTime(LocalDateTime tracingTime) {
        this.tracingTime = tracingTime;
    }
}
