package com.liquidnet.service.goblin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 商铺商品分类
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinStoreGoodsCategory implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 店铺id
     */
    private String storeId;

    /**
     * 分类id
     */
    private String cateId;

    /**
     * 分类名称
     */
    private String name;

    /**
     * 排序[数值越小,排序越前]
     */
    private Integer sort;

    /**
     * 分类层级[1-一级|2-二级|3-三级]
     */
    private String grade;

    /**
     * 父级分类id
     */
    private String catePid;

    /**
     * 是否需要填写ISBN[0-否|1-是]
     */
    private String neIsbn;

    /**
     * 删除标记[0-未删除|1-删除]
     */
    private String delFlg;

    private String createdBy;

    private LocalDateTime createdAt;

    private String updatedBy;

    private LocalDateTime updatedAt;

    private String deletedBy;

    private LocalDateTime deletedAt;

    private String comment;


}
