package com.liquidnet.service.sweet.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetManualShop;
import com.liquidnet.service.sweet.entity.SweetManualShopMdsk;
import com.liquidnet.service.sweet.service.ISweetManualShopMdskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 电子宣传手册商铺表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Api(tags = "电子手册吃喝玩乐_MDSK")
@RestController
@RequestMapping("/mdsk/sweet-manual-shop-mdsk")
public class SweetManualShopMdskController {

    @Autowired
    ISweetManualShopMdskService sweetManualShopMdskService;

    @GetMapping("list")
    @ApiOperation("列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "类型 1吃喝 2玩乐", required = true),
    })
    public ResponseDto<List<SweetManualShopMdsk>> getList(@RequestParam String manualId,
                                                          @RequestParam Integer type) {
        return sweetManualShopMdskService.getList(manualId, type);
    }

    @GetMapping("details")
    @ApiOperation("详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualShopId", value = "商铺id", required = true),
    })
    public ResponseDto<SweetManualShopMdsk> details(@RequestParam String manualShopId) {
        return sweetManualShopMdskService.details(manualShopId);
    }

    @PostMapping("add")
    @ApiOperation("添加")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册iid", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "title", value = "标题", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "picUrl", value = "图片地址", required = false),
            @ApiImplicitParam(type = "query", dataType = "String", name = "describes", value = "描述", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "类型 1吃喝 2玩乐", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isRecommend", value = "是否推荐", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "sort", value = "排序", required = true),
    })
    public ResponseDto<Boolean> add(@RequestParam String manualId,
                                    @RequestParam String title,
                                    @RequestParam String picUrl,
                                    @RequestParam String describes,
                                    @RequestParam Integer type,
                                    @RequestParam Integer isRecommend,
                                    @RequestParam Integer sort) {
        return sweetManualShopMdskService.add(manualId, title, picUrl, describes, type, isRecommend, sort);
    }

    @PostMapping("change")
    @ApiOperation("修改")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualShopId", value = "商铺id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "title", value = "标题", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "picUrl", value = "图片地址", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "describes", value = "描述", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "类型 1吃喝 2玩乐", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "isRecommend", value = "是否推荐", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "sort", value = "排序", required = true),
    })
    public ResponseDto<Boolean> change(@RequestParam String manualShopId,
                                       @RequestParam String manualId,
                                       @RequestParam String title,
                                       @RequestParam String picUrl,
                                       @RequestParam String describes,
                                       @RequestParam Integer type,
                                       @RequestParam Integer isRecommend,
                                       @RequestParam Integer sort) {
        return sweetManualShopMdskService.change(manualShopId, manualId, title, picUrl, describes, type, isRecommend, sort);
    }


    @DeleteMapping("delete")
    @ApiOperation("删除")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualShopId", value = "商铺id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "manualId", value = "手册id", required = true),
    })
    public ResponseDto<Boolean> delete(@RequestParam() String manualShopId,
                                       @RequestParam String manualId) {
        return sweetManualShopMdskService.delete(manualShopId, manualId);
    }

}
