package com.liquidnet.service.goblin.service;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinNftExCodeVo;
import com.liquidnet.service.goblin.dto.vo.PageInfoVo;
import com.liquidnet.service.goblin.param.GoblinNftExCodeParam;

import javax.servlet.http.HttpServletResponse;

public interface IGoblinNftExCodeService {

    /**
     * 获取兑换码
     */
    PageInfoVo selectCodePageList(GoblinNftExCodeParam goblinNftExCodeParam);

    /**
     * 兑换码主动失效
     * @param codeIds
     * @return
     */
    Boolean defDrivLoseCode(String codeIds);

    /**
     * 空投发送
     * @param goblinNftExCodeParam
     * @return
     */
    ResponseDto<Boolean> addAirdrop(GoblinNftExCodeParam goblinNftExCodeParam);

    /**
     * 兑换码导出
     * @param httpServletResponse
     * @param goblinNftExCodeParam
     */
    void excel(HttpServletResponse httpServletResponse, GoblinNftExCodeParam goblinNftExCodeParam);
}
