package com.liquidnet.client.admin.zhengzai.smile.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.utils.StringUtils;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileAgentService;
import com.liquidnet.client.admin.zhengzai.smile.utils.SmileRedisUtils;
import com.liquidnet.service.goblin.dto.vo.SmileAgentVo;
import com.liquidnet.service.kylin.mapper.KylinPerformancesMapper;
import com.liquidnet.service.kylin.mapper.KylinTicketsMapper;
import com.liquidnet.service.smile.entity.SmileAgent;
import com.liquidnet.service.smile.entity.dao.SmileAgentDao;
import com.liquidnet.service.smile.mapper.SmileAgentMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-16
 */
@Service
@Slf4j
public class SmileAgentServiceImpl extends ServiceImpl<SmileAgentMapper, SmileAgent> implements ISmileAgentService {

    @Autowired
    SmileAgentMapper smileAgentMapper;

    @Autowired
    SmileRedisUtils smileRedisUtils;

    @Autowired
    KylinTicketsMapper kylinTicketsMapper;

    @Autowired
    KylinPerformancesMapper kylinPerformancesMapper;

    @Override
    public SmileAgent listAgentByShowIdAndTicketId(String performanceId, String ticketId) {
        if (StringUtils.isNotEmpty(performanceId) && StringUtils.isNotEmpty(ticketId)) {
            LambdaQueryWrapper<SmileAgent> queryWrapper = Wrappers.lambdaQuery(SmileAgent.class);
            queryWrapper.eq(SmileAgent::getPerformanceId, performanceId);
            queryWrapper.eq(SmileAgent::getTicketId, ticketId);
            queryWrapper.eq(SmileAgent::getDelTag,0);
            smileAgentMapper.selectOne(queryWrapper);
            return null;
        }
        return null;
    }

    @Override
    public AjaxResult create(List<SmileAgent> smileAgents) {
        boolean result = true;
        if (StringUtils.isNotEmpty(smileAgents)) {
            for (SmileAgent agent : smileAgents) {
                result = !StringUtils.isEmpty(agent.getPerformanceId()) && !StringUtils.isEmpty(agent.getTicketId());
            }
            if (result) {
                try {
                    for (SmileAgent smileAgent : smileAgents){
                        SmileAgentVo agent = smileRedisUtils.getAgent(smileAgent.getPerformanceId(),smileAgent.getTicketId());
                        if (agent!=null){
                            log.info("SmileAgent:{}",agent);
                            //修改过票提则无法再次修改
                            return AjaxResult.warn("票提一但设置，无法修改！");
                        }
                    }
                    smileAgents.forEach(smileAgent -> {
                        //是否是修改票提
                        smileAgentMapper.updateAgentById(smileAgent.getId(),smileAgent.getTotalCarry(),smileAgent.getOrdCarry());
                        SmileAgentVo smileAgentVo = new SmileAgentVo();
                        BeanUtils.copyProperties(smileAgent, smileAgentVo);
                        smileRedisUtils.setAgent(smileAgent.getPerformanceId(),smileAgent.getTicketId(), smileAgentVo);
                        log.debug("create create Agent id：{},PerformanceId:{},TicketId:{}",
                                smileAgent.getId(),
                                smileAgent.getPerformanceId(),
                                smileAgent.getTicketId());
                    });
                    return AjaxResult.success();
                } catch (Exception e) {
                    e.printStackTrace();
                    return AjaxResult.warn("请重试");
                }
            }
        }
        return AjaxResult.success();
    }

    @Override
    public AjaxResult getAgent(String performancesId) {
        List<SmileAgentDao> smileAgentDaoList = smileAgentMapper.selectAgentList(performancesId);
        if (smileAgentDaoList != null && smileAgentDaoList.size() > 0){
            return AjaxResult.success(smileAgentDaoList);
        }
        return AjaxResult.warn("演出未开启代理");
    }
}
