package com.liquidnet.service.kylin.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.KylinLuckyBagCodeDetailVo;
import com.liquidnet.service.kylin.dto.vo.KylinLuckyBagScopeVo;
import com.liquidnet.service.kylin.dto.vo.KylinLuckyBagVo;
import com.liquidnet.service.kylin.service.IKylinLuckyBagService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "前端-获取福袋相关")
@RestController
@RequestMapping("/luckyBag")
@Slf4j
public class KylinLuckyBagController {

    @Autowired
    private IKylinLuckyBagService luckyBagService;


    @GetMapping("")
    @ApiOperation("获取福袋权益列表")
    public ResponseDto<KylinLuckyBagVo> getLuckyBagByOrderId(@RequestParam(value = "orderId") String orderId) {
        return ResponseDto.success(luckyBagService.getLuckyBagByOrderId(orderId));
    }


    @GetMapping("/scope")
    @ApiOperation("获取验码福袋列表")
    public ResponseDto<List<KylinLuckyBagScopeVo>> getLuckyBagListScope(@RequestParam(value = "mobile") String mobile,
                                                                        @RequestParam(value = "performanceId", required = false) String performanceId){
        return ResponseDto.success(luckyBagService.getLuckyBagListScope(mobile, performanceId));
    }

    @ApiOperation("兑换码详情")
    @GetMapping("/code/detail")
    public ResponseDto<KylinLuckyBagCodeDetailVo> getCodeDetail(@RequestParam(value = "code") String code,
                                                                @RequestParam(value = "luckyBagId") String luckyBagId){
        return ResponseDto.success(luckyBagService.getCodeDetail(code, luckyBagId));
    }

    @GetMapping("/code/consume")
    @ApiOperation("兑换码核销")
    public ResponseDto<Boolean> consumeCode(@RequestParam(value = "code") String code,
                                            @RequestParam(value = "luckyBagId") String luckyBagId){
        return luckyBagService.consumeCode(code, luckyBagId);
    }
}
