package com.liquidnet.service.kylin.entity;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 订单
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinOrderTickets implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * order_tickets_id
     */
    private String orderTicketsId;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 用户昵称
     */
    private String userName;

    /**
     * 用户手机号
     */
    private String userMobile;

    /**
     * 演出名称
     */
    private String performanceTitle;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 支付订单号
     */
    private String payCode;

    /**
     * 二维码地址
     */
    private String qrCode;

    /**
     * 下单方式
     */
    private String orderType;

    /**
     * 下单来源
     */
    private String orderSource;

    /**
     * 下单版本
     */
    private String orderVersion;

    /**
     * 数量
     */
    private Integer number;

    /**
     * 单价
     */
    private BigDecimal price;

    /**
     * 会员单价
     */
    private BigDecimal priceMember;

    /**
     * 应付价格
     */
    private BigDecimal priceTotal;

    /**
     * 优惠价格
     */
    private BigDecimal priceVoucher;

    /**
     * 实付价格
     */
    private BigDecimal priceActual;

    /**
     * 快递价格
     */
    private BigDecimal priceExpress;

    /**
     * 退款价格
     */
    private BigDecimal priceRefund;

    /**
     * 退款扣除的手续费金额
     */
    private BigDecimal refundPriceCharges;

    /**
     * 退款张数
     */
    private Integer refundNumber;

    /**
     * 选择支付方式
     */
    private String payType;

    /**
     * 实际支付方式
     */
    private String paymentType;

    /**
     * 支付的订单号
     */
    private String paymentId;

    /**
     * 支付时间
     */
    private String timePay;

    /**
     * 收货人
     */
    private String expressContacts;

    /**
     * 收货地址
     */
    private String expressAddress;

    /**
     * 城市
     */
    private String city;

    /**
     * 区县
     */
    private String county;

    /**
     * 省份
     */
    private String province;

    /**
     * 收货人联系方式
     */
    private String expressPhone;

    /**
     * 券使用类别
     */
    private String couponType;

    /**
     * 取票方式 电子票electronic快递票express
     */
    private String getTicketType;

    /**
     * 直播用取票观演码，隔开
     */
    private String getTicketDescribe;

    /**
     * 订单过期时间
     */
    private Integer payCountdownMinute;

    /**
     * ip地址
     */
    private String ipAddress;

    /**
     * comment
     */
    private String comment;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

    /**
     * 获取 添加 数据库参数
     *
     * @return
     */
    public Object[] getAddObject(String ipAddress) {
        return new Object[]{
                orderTicketsId, userId, userName, userMobile, performanceTitle, orderCode, qrCode, orderType, orderVersion,
                number, price, priceMember, priceTotal, priceVoucher, priceActual, priceExpress, priceRefund, refundNumber,
                payType, paymentType, timePay, expressContacts, expressAddress, expressPhone, couponType, getTicketType,
                getTicketDescribe, payCountdownMinute, comment, createdAt, updatedAt, payCode,ipAddress
        };
    }

    /**
     * 获取 再次支付 数据库参数
     *
     * @return
     */
    public Object[] getPayAgainObject(LocalDateTime updateTime, LocalDateTime createTime) {
        return new Object[]{
                updatedAt, payCode, payType, orderTicketsId, updateTime, createTime
        };
    }

    /**
     * 获取 支付回调 数据库参数
     *
     * @return
     */
    public Object[] getSynOrderObject(LocalDateTime updateTime, LocalDateTime createTime) {
        return new Object[]{
                paymentId, paymentType, payCode, timePay, qrCode, updatedAt, orderTicketsId, updateTime, createTime
        };
    }

    /**
     * 获取 订单关闭 数据参数
     *
     * @return
     */
    public Object[] getCloseOrderObject() {
        return new Object[]{
                updatedAt, orderTicketsId
        };
    }

    private static final KylinOrderTickets obj = new KylinOrderTickets();

    public static KylinOrderTickets getNew() {
        try {
            return (KylinOrderTickets) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinOrderTickets();
        }
    }
}
