package com.liquidnet.service.consumer.sweet.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.entity.SweetWechatUser;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class RedisDataUtils {

    @Autowired
    private RedisUtil redisUtil;

    public SweetWechatUser getSweetWechatUser(String unionid) {
        if (unionid.isEmpty()) {
            return null;
        }
        String redisKey = SweetConstant.REDIS_KEY_SWEET_WECHAT_USER_INFO.concat(unionid);
        return (SweetWechatUser) redisUtil.get(redisKey);
    }

}
