package com.liquidnet.service.dragon.controller;

import com.liquidnet.service.dragon.service.IDragonOrdersService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: PayNotifyController
 * @Package com.liquidnet.service.dragon.controller
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/11 23:35
 */
@RestController
@RequestMapping("notify")
public class PayNotifyController {
    @Autowired
    private IDragonOrdersService dragonOrdersService;
    /**
     * 支付宝支付回调
     * @return
     */
    @PostMapping("/{payType}/{deviceFrom}")
    @ApiOperation("支付宝支付回调")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "payType", value = "支付类型:alipay,wepay,iappay", example = "alipay")
    })
    public String dragonNotify(@PathVariable("payType") String payType,@PathVariable("deviceFrom") String deviceFrom,HttpServletRequest request, HttpServletResponse respone) throws Exception {
        return dragonOrdersService.dragonNotify(request,payType,deviceFrom);
    }
}
